/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.gui.jdialogs;

import at.glawar.javaframework.gui.base.BaseJDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DialogAddDBConnection
extends BaseJDialog {
    private boolean configurationChanged = false;
    private String dbType = "";
    private Object[][] dbParams = null;
    private String[] columnNames = new String[]{"parameter", "value"};
    private JComboBox availableDatabases;
    private JButton buttonAddDBConnection;
    private JButton buttonClose;
    private JButton buttonSaveAndClose;
    private JButton buttonTestConnection;
    private JScrollPane panelScroll;
    private JTable tableDBParams;

    public DialogAddDBConnection(Frame parent, boolean modal, String alignment) {
        super(parent, modal, alignment);
        this.initComponents();
        this.setTitle("Add new DB-Connection");
        this.availableDatabases.setModel(new DefaultComboBoxModel<String>(new String[]{"Firebird", "MSSQL", "MySQL", "Oracle", "SQLite"}));
        this.alignDialog();
    }

    private void saveConfig() {
        int i;
        int numRows = this.tableDBParams.getRowCount();
        TableModel model = this.tableDBParams.getModel();
        String sectionName = "";
        for (i = 0; i < numRows; ++i) {
            if ("NameOfDB".compareTo((String)model.getValueAt(i, 0)) != 0) continue;
            sectionName = (String)model.getValueAt(i, 1);
        }
        this.mainBase.getConfigFile().setConfigFileValue(sectionName, "databasetyp", this.dbType);
        for (i = 0; i < numRows; ++i) {
            if ("NameOfDB".compareTo((String)model.getValueAt(i, 0)) == 0) continue;
            this.mainBase.getConfigFile().setConfigFileValue(sectionName, (String)model.getValueAt(i, 0), (String)model.getValueAt(i, 1));
        }
        try {
            this.mainBase.getConfigFile().storeConfigFile();
        }
        catch (IOException ex) {
            this.mainGui.addOutputText("Configuration File could not be saved");
            this.mainBase.getLogFile().log2File(ex);
        }
    }

    private void closeMe() {
        if (this.configurationChanged) {
            int n = JOptionPane.showConfirmDialog(this, "Will you save the actual database connection settings?", "Saving DBConnection settings", 0);
            if (n == 1) {
                this.dispose();
            } else if (n == 0) {
                this.saveConfig();
                this.dispose();
            }
        }
        this.dispose();
    }

    @Override
    protected void formWindowClosing(WindowEvent evt) {
        this.closeMe();
    }

    private void createDefaultSQLLiteParameters() {
        this.dbParams = new Object[6][2];
        this.dbParams[0][0] = "NameOfDB";
        this.dbParams[0][1] = "My DatabaseName";
        this.dbParams[1][0] = "fullFileName";
        this.dbParams[1][1] = "/home/databases/sqlite/MyFirstDatabase.sqlite";
        this.dbParams[2][0] = "SelectTypes";
        this.dbParams[2][1] = "select distinct tabname from import order by tabname";
        this.dbParams[3][0] = "SelectTelegram";
        this.dbParams[3][1] = "select rc, colname, laenge from import where tabname = 'TELEGRAMTYPE' order by rc";
        this.dbParams[4][0] = "TelegramTerminator";
        this.dbParams[4][1] = "cr";
        this.dbParams[5][0] = "TelegramDelimiter";
        this.dbParams[5][1] = "";
    }

    private void initComponents() {
        this.availableDatabases = new JComboBox();
        this.buttonAddDBConnection = new JButton();
        this.buttonTestConnection = new JButton();
        this.buttonSaveAndClose = new JButton();
        this.buttonClose = new JButton();
        this.panelScroll = new JScrollPane();
        this.tableDBParams = new JTable();
        this.setDefaultCloseOperation(0);
        this.availableDatabases.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonAddDBConnection.setText("Add");
        this.buttonAddDBConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonAddDBConnectionActionPerformed(evt);
            }
        });
        this.buttonTestConnection.setText("Test Connection");
        this.buttonTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonTestConnectionActionPerformed(evt);
            }
        });
        this.buttonSaveAndClose.setText("Save and Close");
        this.buttonSaveAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonSaveAndCloseActionPerformed(evt);
            }
        });
        this.buttonClose.setText("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonCloseActionPerformed(evt);
            }
        });
        this.tableDBParams.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"parameter", "value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.panelScroll.setViewportView(this.tableDBParams);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelScroll).addGroup(layout.createSequentialGroup().addComponent(this.availableDatabases, -2, 254, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonAddDBConnection, -1, 73, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonTestConnection, -2, 157, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSaveAndClose, -2, 148, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose, -2, 81, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.availableDatabases, -2, -1, -2).addComponent(this.buttonAddDBConnection).addComponent(this.buttonTestConnection).addComponent(this.buttonSaveAndClose).addComponent(this.buttonClose)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelScroll, -2, 126, -2).addContainerGap(236, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonAddDBConnectionActionPerformed(ActionEvent evt) {
        this.mainBase.debug("Add clicked");
        this.configurationChanged = true;
        int index = this.availableDatabases.getSelectedIndex();
        if ("SQLite".compareTo((String)this.availableDatabases.getItemAt(index)) == 0) {
            this.dbType = "SQLite";
            this.createDefaultSQLLiteParameters();
        } else {
            this.mainGui.addOutputText("<" + (String)this.availableDatabases.getItemAt(index) + "> not supported yet");
        }
        this.tableDBParams = new JTable();
        this.tableDBParams.setModel(new DefaultTableModel(this.dbParams, this.columnNames){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tableDBParams.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                DialogAddDBConnection.this.configurationChanged = true;
            }
        });
        this.panelScroll.setViewportView(this.tableDBParams);
    }

    private void buttonTestConnectionActionPerformed(ActionEvent evt) {
    }

    private void buttonSaveAndCloseActionPerformed(ActionEvent evt) {
        this.saveConfig();
        this.dispose();
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.closeMe();
    }
}

