/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework;

import at.glawar.javaframework.exceptions.JFBaseException;
import at.glawar.javaframework.exceptions.JFVersionNegativException;
import at.glawar.javaframework.files.ConfigFile;
import at.glawar.javaframework.files.LogFile;
import at.glawar.javaframework.utils.Files;
import at.glawar.javaframework.utils.RunMe;
import at.glawar.javaframework.utils.StopWatch;
import at.glawar.javaframework.utils.VersionObject;
import at.glawar.javaframework.utils.ZipUtils;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class MainBase {
    private boolean isDebug;
    private String fullConfigDirectory;
    private String fullConfigFileName;
    private ConfigFile configFile;
    private LogFile logfile;
    private String fullLogFile;
    private List listFrameClasses;
    private List listFrame;
    private JDesktopPane panelDesktop;
    private String fullBaseDir = null;
    private VersionObject myVersion = new VersionObject();
    private VersionObject javaFramework = null;
    private String updateSubDirectory = "update";
    private String automaticUpdate = "0";
    private String updateurl = null;
    private boolean useUpdateProxy = false;
    private String updateProxy = null;
    private int updateProxyPort = 80;
    private String localInfo = null;
    private String httpInfo = null;
    private String versionInfo = "version.info";
    private String httpProgram = null;
    private String localProgram = null;
    private String updateVersion = null;
    private String updateProgram = null;
    private Date nextUpdate = null;
    private int maxArchives = 0;
    public String helpFile = null;

    public void MainBase() {
        this.setAppVersion(1);
        this.setAppSubVersion(0);
        this.setAppRevision(1);
    }

    protected void initialize() {
        if (this.listFrameClasses == null) {
            this.listFrameClasses = new ArrayList();
        }
        if (this.listFrame == null) {
            this.listFrame = new ArrayList();
        }
        if (this.javaFramework == null) {
            try {
                this.javaFramework = new VersionObject("1.4.351");
            }
            catch (JFBaseException ex) {
                this.getLogFile().log2File(ex);
            }
        }
    }

    public String getJavaFullBaseDir() {
        return this.fullBaseDir;
    }

    public String getDefaultJavaDir() {
        if ("/".compareTo(File.separator) == 0) {
            return "/opt/glawar.at/java";
        }
        return "C:\\Programme\\glawar.at\\Java";
    }

    public String getDefaultLogDir() {
        if ("/".compareTo(File.separator) == 0) {
            return "/var/log/glawar.at";
        }
        return "C:\\log\\glawar.at";
    }

    public void init() {
        String PREOUTTEXT = "MainBase.init()";
        this.initialize();
        this.fullConfigDirectory = System.getProperty("user.home") + File.separator + "." + this.getApplicationName();
        this.logfile = new LogFile(this.getApplicationName());
        File configDir = new File(this.fullConfigDirectory);
        if (!configDir.exists()) {
            this.debug("Creating config directory <" + configDir.getAbsolutePath() + ">", "MainBase.init()");
            configDir.mkdirs();
        }
        if (this.isDevelopmentVersion()) {
            this.debug("isDevelopmentVersion() is set to TRUE", "MainBase.init()");
            this.fullConfigFileName = this.fullConfigDirectory + File.separator + "development.ini";
        } else {
            this.fullConfigFileName = this.fullConfigDirectory + File.separator + this.getApplicationName() + ".ini";
        }
        File fConfig = new File(this.fullConfigFileName);
        if (!fConfig.exists()) {
            this.debug("ConfigFile <" + this.fullConfigFileName + "> does not exist", "MainBase.init()");
            try {
                fConfig.createNewFile();
            }
            catch (IOException ex) {
                this.err("Cannot create config.ini <" + this.fullConfigFileName + ">", "MainBase.init()");
                this.err(ex, "MainBase.init");
                this.closeApplication(4);
            }
        } else {
            this.debug("ConfigFile <" + this.fullConfigFileName + "> exists", "MainBase.init()");
        }
        this.configFile = new ConfigFile();
        try {
            this.configFile.setFullConfigFilePath(this.fullConfigFileName);
        }
        catch (Exception ex) {
            this.err("config.file <" + this.fullConfigFileName + "> cannot be used", "MainBase.init()");
            this.err(ex, "MainBase.init()");
            this.closeApplication(1);
        }
        String myTempLogDir = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "logfiledir");
        if (myTempLogDir != null) {
            this.debug("Setting log directory <" + myTempLogDir + "> from config file", "MainBase.init()");
            File temp = new File(myTempLogDir);
            if (!temp.exists()) {
                try {
                    temp.createNewFile();
                }
                catch (IOException ex) {
                    this.err("config.file <" + this.fullConfigFileName + "> cannot be used", "MainBase.init()");
                    this.err(ex, "MainBase.init()");
                }
            }
            this.fullLogFile = myTempLogDir + File.separator + this.getApplicationName();
        } else {
            this.fullLogFile = this.getDefaultLogDir() + File.separator + this.getApplicationName();
            this.debug("Setting log directory <" + myTempLogDir + "> because it is not set yet", "MainBase.init()");
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "logfiledir", this.fullLogFile);
        }
        try {
            this.debug("LogFile <" + this.fullLogFile + "> creating", "MainBase.init()");
            this.logfile.setLogFile(this.fullLogFile);
        }
        catch (IOException ex) {
            this.err("Error creating LogFile <" + this.fullLogFile + ">", "MainBase.init()");
            this.err(ex, "MainBase.init()");
        }
        this.logApplicationInfos();
        this.doSomeTesting();
        this.fullBaseDir = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "javaBaseDir");
        if (this.fullBaseDir == null) {
            this.fullBaseDir = this.getDefaultJavaDir();
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "javaBaseDir", this.fullBaseDir);
        }
        this.automaticUpdate = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "updateAutomatically");
        if (this.automaticUpdate == null) {
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "updateurl", "http://software.glawar.at/javaframework/download/");
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "updateuseproxy", "0");
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "updateproxy", "proxyname.com");
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "updateproxyport", "80");
            this.automaticUpdate = "0";
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "updateAutomatically", this.automaticUpdate);
            this.getConfigFile().setConfigFileValue(this.getApplicationName(), "nextAutomaticUpdate", "0");
        }
        if ("0".compareTo(this.automaticUpdate) == 0) {
            this.debug("No automatic update choosen", "MainBase.init()");
        } else {
            String tempIni = null;
            long nextUpdateLong = Long.parseLong(this.getConfigFile().getConfigFileValue(this.getApplicationName(), "nextAutomaticUpdate"));
            this.nextUpdate = new Date(nextUpdateLong);
            this.updateurl = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "updateurl");
            tempIni = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "updateuseproxy");
            if ("1".compareTo(tempIni) == 0) {
                this.useUpdateProxy = true;
            }
            if (this.useUpdateProxy) {
                this.updateProxy = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "updateproxy");
                tempIni = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "updateproxyport");
                this.updateProxyPort = Integer.valueOf(tempIni);
            }
            this.debug(this.getApplicationName() + ".Automatic update chossen", "MainBase.init()");
            this.debug(this.getApplicationName() + ".UpdateUrl <" + this.updateurl + ">", "MainBase.init()");
            if (this.useUpdateProxy) {
                this.debug(this.getApplicationName() + ".UpdateProxyName <" + this.updateProxy + ">", "MainBase.init()");
                this.debug(this.getApplicationName() + ".UpdateProxyPort <" + this.updateProxyPort + ">", "MainBase.init()");
            }
            this.localInfo = this.getFullConfigDirectory() + File.separator + this.updateSubDirectory;
            this.httpInfo = this.updateurl + this.versionInfo;
            File localInfoFile = new File(this.localInfo);
            if (!localInfoFile.exists()) {
                localInfoFile.mkdirs();
            }
            this.localInfo = this.localInfo + File.separator + this.versionInfo;
        }
        try {
            this.maxArchives = Integer.parseInt(this.getConfigFile().getConfigFileValue(this.getApplicationName(), "maxArchives"));
        }
        catch (Exception ex) {
            this.maxArchives = 5;
        }
        this.debug("maxArchives <" + this.maxArchives + ">", "MainBase.init()");
        this.getConfigFile().setConfigFileValue(this.getApplicationName(), "maxArchives", "" + this.maxArchives);
        this.helpFile = this.getConfigFile().getConfigFileValue(this.getApplicationName(), "helpFile");
        if (this.helpFile == null) {
            this.helpFile = this.getDefaultJavaDir() + File.separator + this.getApplicationName() + File.separator + "help.html";
        }
        this.getConfigFile().setConfigFileValue(this.getApplicationName(), "helpFile", this.helpFile);
    }

    private void logApplicationInfos() {
        String PREOUTTEXT = "MainBase.logApplicationInfos";
        if (this.isDebug) {
            this.debug("DebugModus ON", PREOUTTEXT);
        }
        if (this.isDevelopmentVersion()) {
            this.debug("DevelopmentVersion YES", PREOUTTEXT);
        }
        this.debug("os.arch is <" + System.getProperty("os.arch") + ">", PREOUTTEXT);
        this.debug("os.name is <" + System.getProperty("os.name") + ">", PREOUTTEXT);
        this.debug("os.version is <" + System.getProperty("os.version") + ">", PREOUTTEXT);
        this.debug("user.name is <" + System.getProperty("user.name") + ">", PREOUTTEXT);
        this.debug("user.home is <" + System.getProperty("user.home") + ">", PREOUTTEXT);
        this.debug("user.dir is <" + System.getProperty("user.dir") + ">", PREOUTTEXT);
        this.debug("java.vendor is <" + System.getProperty("java.vendor") + ">", PREOUTTEXT);
        this.debug("java.home is <" + System.getProperty("java.home") + ">", PREOUTTEXT);
        this.debug("java.version is <" + System.getProperty("java.version") + ">", PREOUTTEXT);
        this.debug("getApplicationName(): " + this.getApplicationName(), PREOUTTEXT);
        this.debug("getProductVersion(): " + this.getProductVersion(), PREOUTTEXT);
        this.logfile.log2File(this.getApplicationName() + " " + this.getProductVersion() + " is based on JavaFramework " + "1.4.351", PREOUTTEXT);
        this.logfile.log2File(this.getApplicationName() + " is using config file <" + this.fullConfigFileName + ">.", PREOUTTEXT);
        this.logfile.log2File(this.getApplicationName() + " is using log file <" + this.fullLogFile + ".log" + ">.", PREOUTTEXT);
        this.logfile.log2File(this.getApplicationName() + " is using err file <" + this.fullLogFile + ".err" + ">.", PREOUTTEXT);
        this.logApplicationAdditionalInfos();
    }

    public void logApplicationAdditionalInfos() {
        String PREOUTTEXT = "MainBase.logApplicationAdditionalInfos";
        Enumeration<Object> em = System.getProperties().keys();
        while (em.hasMoreElements()) {
            String str = (String)em.nextElement();
            this.debug(str + ": " + System.getProperties().get(str), PREOUTTEXT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFileFromWeb(String source, String dest) {
        String PRETEXT = "MainBase.downloadFileFromWeb2()";
        boolean succ = true;
        URL url = null;
        OutputStream out = null;
        URLConnection conn = null;
        InputStream in = null;
        Proxy proxy = null;
        try {
            int numRead;
            StopWatch.resetTime("downloadFileFromWeb");
            url = new URL(source);
            out = new BufferedOutputStream(new FileOutputStream(dest));
            if (this.useUpdateProxy) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.updateProxy, this.updateProxyPort));
                conn = url.openConnection(proxy);
            } else {
                conn = url.openConnection();
            }
            in = conn.getInputStream();
            byte[] buffer = new byte[1024];
            long numWritten = 0L;
            while ((numRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, numRead);
                numWritten += (long)numRead;
            }
            this.debug(StopWatch.getDisplayString("downloadFileFromWeb"), PRETEXT);
        }
        catch (FileNotFoundException ex) {
            this.getLogFile().log2File(ex);
            succ = false;
        }
        catch (MalformedURLException ex) {
            this.getLogFile().log2File(ex);
            succ = false;
        }
        catch (IOException ex) {
            this.getLogFile().log2File(ex);
            succ = false;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {}
            try {
                out.close();
            }
            catch (Exception ex) {}
        }
        return succ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readInfoFile() {
        boolean succ = true;
        BufferedReader br = null;
        String PRETEXT = "MainBase.readInfoFile()";
        try {
            br = new BufferedReader(new FileReader(this.localInfo));
            String line = br.readLine();
            int i = 0;
            while (line != null) {
                if (i == 0) {
                    this.updateVersion = line;
                } else {
                    this.updateProgram = line;
                }
                line = br.readLine();
                ++i;
            }
        }
        catch (FileNotFoundException ex) {
            this.err(ex, null);
            succ = false;
        }
        catch (IOException ioex) {
            this.err(ioex, null);
            succ = false;
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {}
        }
        this.debug(this.getApplicationName() + ".Version <" + this.updateVersion + ">", PRETEXT);
        this.debug(this.getApplicationName() + ".Program <" + this.updateProgram + ">", PRETEXT);
        this.httpProgram = this.updateurl + this.updateProgram;
        this.localProgram = this.getFullConfigDirectory() + File.separator + this.updateSubDirectory + File.separator + this.updateProgram;
        return succ;
    }

    private boolean isUpdateNecessary() {
        boolean necessary = false;
        VersionObject netVersion = null;
        try {
            netVersion = new VersionObject(this.updateVersion);
            this.debug("MyVersion <" + this.myVersion.getFullVersion() + ">", this.getApplicationName());
            this.debug("NetVersion <" + netVersion.getFullVersion() + ">", this.getApplicationName());
            necessary = netVersion.isGreaterThan(this.myVersion);
        }
        catch (JFBaseException ex) {
            this.getLogFile().log2File(ex);
        }
        return necessary;
    }

    public boolean update() {
        String PREOUTTEXT = "MainBase.update()";
        boolean succ = false;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        if ("0".compareTo(this.automaticUpdate) == 0) {
            this.debug("AutomaticUpdate is not activated", PREOUTTEXT);
            return succ;
        }
        this.debug("AutomaticUpdate is activated", PREOUTTEXT);
        if (now.compareTo(this.nextUpdate) < 0) {
            this.debug("Next time I will search for an update <" + dateFormat.format(this.nextUpdate) + ">", PREOUTTEXT);
            return succ;
        }
        this.debug("Searching for update now", PREOUTTEXT);
        cal.add(5, this.getDays4NextUpdate());
        now = cal.getTime();
        this.getConfigFile().setConfigFileValue(this.getApplicationName(), "nextAutomaticUpdate", now.getTime());
        succ = this.downloadFileFromWeb(this.httpInfo, this.localInfo);
        if (succ) {
            this.debug("info file downloaded", PREOUTTEXT);
            succ = this.readInfoFile();
            if (succ && (succ = this.isUpdateNecessary())) {
                this.debug("New Version available for " + this.getApplicationName(), PREOUTTEXT);
                succ = this.downloadFileFromWeb(this.httpProgram, this.localProgram);
                if (succ) {
                    try {
                        ZipUtils.extract(this.localProgram, this.getFullConfigDirectory() + File.separator + this.updateSubDirectory);
                    }
                    catch (FileNotFoundException ex) {
                        this.getLogFile().log2File(ex, PREOUTTEXT);
                        succ = false;
                    }
                    catch (IOException ex) {
                        this.getLogFile().log2File(ex, PREOUTTEXT);
                        succ = false;
                    }
                }
                if (succ) {
                    this.copyJavaFramework();
                    this.copyFiles();
                    try {
                        this.getConfigFile().storeConfigFile();
                    }
                    catch (IOException ex) {
                        this.getLogFile().log2File(ex);
                    }
                }
            }
        }
        return succ;
    }

    public String getUpdateDirectory() {
        return this.getFullConfigDirectory() + File.separator + this.updateSubDirectory + File.separator + this.getApplicationName();
    }

    private void copyJavaFramework() {
        String PRETEXT = "MainBase.copyJavaFramework()";
        String source = null;
        String target = null;
        source = this.getUpdateDirectory() + File.separator + "lib" + File.separator + "lib" + File.separator + "JavaFramework.jar";
        target = this.getJavaFullBaseDir() + File.separator + "lib" + File.separator + "glawar.at";
        int installedJavaFrameworkRevision = this.getSVNRevisionOfJavaFramework();
        String newJavaFrameworkRevision = null;
        try {
            newJavaFrameworkRevision = RunMe.runJarFile(source);
            int newVersion = Integer.parseInt(newJavaFrameworkRevision);
            if (newVersion > installedJavaFrameworkRevision) {
                this.debug("Copy <" + source + "> to <" + target + ">", PRETEXT);
                try {
                    Files.copyFileWithBackup(this, source, target, this.maxArchives);
                }
                catch (IOException ex) {
                    this.getLogFile().log2File(ex);
                }
            } else {
                this.debug("actual JavaFramework (Revision <" + installedJavaFrameworkRevision + ">) is higher than the one that should be installed (Revision <" + newVersion + ">)", PRETEXT);
            }
        }
        catch (IOException ex) {
            this.getLogFile().log2File(ex);
        }
        catch (InterruptedException ex) {
            this.getLogFile().log2File(ex);
        }
    }

    public int getmaxArchives() {
        return this.maxArchives;
    }

    public int getDays4NextUpdate() {
        return 7;
    }

    public void copyFiles() {
    }

    public int getAllInternalFrames() {
        return this.panelDesktop.getAllFrames().length;
    }

    public void setPanelDesktop(JDesktopPane panelDesktop) {
        this.panelDesktop = panelDesktop;
    }

    public String getLanguageEntry(String key) {
        String PREOUTTEXT = "MainBase.getLanguageEntry";
        String retVal = null;
        try {
            retVal = ResourceBundle.getBundle("at/glawar/javaframework/bundles/Language").getString(key);
        }
        catch (Exception ex) {
            this.err(ex, "MainBase.getLanguageEntry");
            retVal = "<" + key + "> is _NOT_DEFINIED_";
        }
        return retVal;
    }

    public LogFile getLogFile() {
        return this.logfile;
    }

    public int getAmountOfFrames() {
        return this.listFrameClasses.size();
    }

    public void removeFrame(JInternalFrame frame) throws PropertyVetoException {
        if (this.isShowingFrame(frame)) {
            frame.setVisible(false);
            this.panelDesktop.remove(frame);
            this.listFrame.remove(frame);
            this.listFrameClasses.remove(frame.getClass().getName());
            JInternalFrame newFrame = this.getLastFrame();
            if (newFrame != null) {
                this.activateFrame(newFrame);
            }
        }
    }

    public JInternalFrame getLastFrame() {
        JInternalFrame[] allframes = this.panelDesktop.getAllFrames();
        if (allframes != null && allframes.length > 0) {
            return allframes[0];
        }
        if (this.listFrame.isEmpty()) {
            return null;
        }
        return (JInternalFrame)this.listFrame.get(this.listFrame.size() - 1);
    }

    public void addFrame(JInternalFrame frame, boolean centerFrame) throws PropertyVetoException {
        String PRETEXT = "MainBase.addFrame";
        this.debug(frame.getName() + " inspecting", PRETEXT);
        if (!this.isShowingFrame(frame)) {
            this.debug(frame.getName() + " is not showing", PRETEXT);
            this.panelDesktop.add(frame);
            this.listFrame.add(frame);
            this.listFrameClasses.add(frame.getClass().getName());
            frame.setMaximum(centerFrame);
        }
        this.activateFrame(frame);
    }

    public void activateFrame(JInternalFrame frame) throws PropertyVetoException {
        if (this.isShowingFrame(frame)) {
            frame.setSelected(true);
            this.panelDesktop.moveToFront(frame);
        }
    }

    public boolean determineArgs(String[] args) {
        if (args.length > 0) {
            System.out.println("args[0]=" + args[0]);
            if (args.length == 1 && args[0].compareTo("revision") == 0) {
                System.out.println(this.getApplicationRevision());
                this.closeApplication(6);
            }
            for (int i = 0; i < args.length; ++i) {
                String string = args[i];
                if (string.toLowerCase().compareTo("debugmodus") == 0) {
                    this.isDebug = true;
                    continue;
                }
                if (string.toLowerCase().compareTo("help") != 0) continue;
                System.out.println("Usage: " + this.getApplicationName() + " [ help | debugmodus ]");
                return false;
            }
        }
        return true;
    }

    public void debug(String debugText) {
        this.debug(debugText, null);
    }

    public void debug(String debugText, String preText) {
        if (this.isDebug) {
            String pre = null;
            pre = preText == null || preText.length() == 0 ? "" : (preText.endsWith(".") ? preText : preText + ".");
            System.out.println("DEBUG-" + pre + debugText);
            if (this.logfile != null) {
                this.logfile.log2File(debugText, "DEBUG-" + pre);
            }
        }
    }

    private void err(String errText, String preText) {
        System.err.println(errText);
        if (this.logfile != null) {
            this.logfile.err2File(errText, preText);
        }
    }

    public boolean isDevelopmentVersion() {
        return false;
    }

    public boolean isDebugModus() {
        return this.isDebug;
    }

    public boolean isShowingFrame(JInternalFrame frame) {
        if (this.listFrame != null) {
            return this.listFrame.contains(frame);
        }
        return false;
    }

    public boolean isShowingFrame(String frameClassName) {
        if (this.listFrameClasses != null) {
            return this.listFrameClasses.contains(frameClassName);
        }
        return false;
    }

    public void err(Throwable th, String preText) {
        String pre = null;
        pre = preText == null || preText.length() == 0 ? "" : preText + ".";
        if (th != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream tmp = new PrintStream(baos);
            th.printStackTrace(tmp);
            this.err(new String(baos.toByteArray()), pre);
        }
        if (this.isDevelopmentVersion()) {
            th.printStackTrace(System.err);
            if (this.logfile != null) {
                this.logfile.err2File(th, pre);
            }
        }
    }

    public String getApplicationName() {
        return "JavaFramework";
    }

    public void closeApplication() {
        this.closeApplication(0);
    }

    public void closeApplication(int exitCode) {
        this.getLogFile().log2File("Exiting " + this.getApplicationName() + " " + this.getProductVersion() + " with exit value <" + exitCode + ">", "closeApplication");
        System.exit(exitCode);
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    public String getAboutDescription() {
        return this.getLanguageEntry("INFO_FRAMEWORK");
    }

    public String getProductVersion() {
        return this.myVersion.getFullVersion();
    }

    public ImageIcon getAboutLogo() {
        return this.createImageIcon("/at/glawar/javaframework/images/JavaFramework-Logo-380x280.png");
    }

    public ImageIcon getApplicationLogo() {
        return this.createImageIcon("/at/glawar/javaframework/icons/javaframework-24x24.gif");
    }

    public ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, null);
        }
        this.getLogFile().log2File("Couldn't find file: <" + path + ">");
        return null;
    }

    public ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        this.getLogFile().log2File("Couldn't find file: <" + path + ">");
        return null;
    }

    public void setAppVersion(int appVersion) {
        try {
            this.myVersion.setVersion(appVersion);
        }
        catch (JFVersionNegativException ex) {
            this.getLogFile().log2File(ex);
        }
    }

    public void setAppSubVersion(int appSubVersion) {
        try {
            this.myVersion.setSubVersion(appSubVersion);
        }
        catch (JFVersionNegativException ex) {
            this.getLogFile().log2File(ex);
        }
    }

    public void setAppRevision(int appRevision) {
        try {
            this.myVersion.setRevision(appRevision);
        }
        catch (JFVersionNegativException ex) {
            this.getLogFile().log2File(ex);
        }
    }

    public int getApplicationRevision() {
        return this.myVersion.getRevision();
    }

    public String getSupportEmail() {
        return "Please define your Email in MainBase";
    }

    public String getHomepageUrl() {
        return "http://software.glawar.at/javaframework/";
    }

    public int getSVNRevisionOfJavaFramework() {
        return this.javaFramework.getRevision();
    }

    public String getFullConfigDirectory() {
        return this.fullConfigDirectory;
    }

    public void doSomeTesting() {
    }

    public String getLanguageEntryPersonal(String key) {
        return "_NOT_DEFINIED_";
    }
}

