/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.gui;

import at.glawar.javaframework.MainBase;
import at.glawar.javaframework.gui.MainGUI;
import at.glawar.ssttool.SSTToolMainBase;
import at.glawar.ssttool.connections.DBConnections;
import at.glawar.ssttool.connections.DBProperties;
import at.glawar.ssttool.gui.iframes.ClientFrame;
import at.glawar.ssttool.gui.iframes.ServerFrame;
import at.glawar.ssttool.gui.jdialogs.DialogAddDBConnection;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public final class SSTToolGUI
extends MainGUI {
    private JMenuItem menuitemServer = null;
    private ServerFrame frameServer = null;
    private JMenuItem menuitemClient = null;
    private ClientFrame frameClient = null;
    private JSeparator menuItemFileSeparator = null;
    private JSeparator menuItemFileSeparator2 = null;
    private JMenuItem menuitemAddDBConnection = null;
    private DialogAddDBConnection addDBConnection;
    private DBConnections dbConnections = null;
    private JMenuItem menuConfiguration = null;
    private JRadioButtonMenuItem[] menuItemRadioConfigurations;
    private DBProperties selectedConnection = null;
    private HelpSet helpSet = null;
    private HelpBroker helpBroker = null;

    public static void main(final String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SSTToolGUI(args).setVisible(true);
            }
        });
    }

    public SSTToolGUI(String[] args) {
        super(args);
        this.myInit();
        try {
            this.initHelp();
        }
        catch (HelpSetException ex) {
            this.mainBase.getLogFile().log2File(ex);
        }
    }

    public HelpSet getHelpSet() {
        return this.helpSet;
    }

    public HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    private void initHelp() throws HelpSetException {
        URL hsURL = HelpSet.findHelpSet(null, (String)"jhelpset.hs");
        this.helpSet = new HelpSet(null, hsURL);
        this.helpBroker = this.helpSet.createHelpBroker();
        this.helpBroker.enableHelpOnButton((Component)this.getMenuHelpMe(), "PROGRAMINFO", this.helpSet);
    }

    public DBProperties getSelectedConnection() {
        return this.selectedConnection;
    }

    public void myInit() {
        String PREOUTTEXT = "TestGui.myInit";
        this.getMainBase().debug("myInit", "TestGui.myInit");
        this.setTitle(this.getMainBase().getApplicationName() + " " + this.getMainBase().getProductVersion());
        this.menuitemAddDBConnection = new JMenuItem();
        this.menuitemAddDBConnection.setText(this.mainBase.getLanguageEntryPersonal("MENU_ADD_DB_CONNECTION"));
        this.menuitemAddDBConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSTToolGUI.this.menuitemAddDBConnectionPerformed(evt);
            }
        });
        this.getMenuConfiguration().add(this.menuitemAddDBConnection);
        ImageIcon img = this.getMainBase().createImageIcon("/at/glawar/ssttool/icons/SSTTool.gif");
        this.setIconImage(img.getImage());
        this.rebuildSocketMenu();
        this.getMenuFile().setText(this.mainBase.getLanguageEntryPersonal("MENU_SOCKET"));
        char[] mnemonics = this.mainBase.getLanguageEntryPersonal("MENU_SOCKET_MNEMONIC").toCharArray();
        this.getMenuFile().setMnemonic(mnemonics[0]);
        this.getOutputWindow().setFont(new Font("Courier", 0, 16));
    }

    private void loadConfig(ActionEvent aEvent) {
        String PRETEXT = "SSTToolGUI.loadConfig";
        this.getMainBase().debug("Loading config for <" + aEvent.getActionCommand() + ">", "SSTToolGUI.loadConfig");
        this.selectedConnection = this.dbConnections.getDBProperties(aEvent.getActionCommand());
        this.getMainBase().debug("DBName <" + this.selectedConnection.getDBName() + "> is of dbType <" + this.selectedConnection.getDBType() + ">", "SSTToolGUI.loadConfig");
        this.getMainBase().debug("Parameter server is <" + this.selectedConnection.getDBPropertyValue("server") + ">", "SSTToolGUI.loadConfig");
        this.getMainBase().debug("Parameter CustomerWatchdog is <" + this.selectedConnection.getGlobalPropertyValue("CustomerWatchdog") + ">", "SSTToolGUI.loadConfig");
    }

    public void rebuildSocketMenu() {
        String PRETEXT = "SSTToolGUI.rebuildSocketMenu";
        this.dbConnections = new DBConnections(this.mainBase);
        this.dbConnections.readDBConnectionsFromIniFile();
        ArrayList alDBConnections = this.dbConnections.getDBConnections();
        this.getMenuFile().removeAll();
        if (alDBConnections.size() > 0) {
            this.mainBase.debug("We have connections", "SSTToolGUI.rebuildSocketMenu");
            this.menuConfiguration = new JMenu();
            this.menuConfiguration.setText(this.mainBase.getLanguageEntryPersonal("MENU_CONFIGS"));
            this.getMenuFile().add(this.menuConfiguration);
            this.menuItemRadioConfigurations = new JRadioButtonMenuItem[alDBConnections.size()];
            Collections.sort(alDBConnections);
            ButtonGroup group = new ButtonGroup();
            for (int i = 0; i < alDBConnections.size(); ++i) {
                this.menuItemRadioConfigurations[i] = new JRadioButtonMenuItem();
                this.menuItemRadioConfigurations[i].setText((String)alDBConnections.get(i));
                group.add(this.menuItemRadioConfigurations[i]);
                this.menuItemRadioConfigurations[i].setActionCommand((String)alDBConnections.get(i));
                this.menuItemRadioConfigurations[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        SSTToolGUI.this.loadConfig(arg0);
                    }
                });
                this.menuConfiguration.add(this.menuItemRadioConfigurations[i]);
            }
            this.getMenuFile().add(this.getFileSeparator2());
        }
        this.menuitemServer = new JMenuItem();
        this.menuitemServer.setText(this.mainBase.getLanguageEntryPersonal("MENU_SERVER"));
        this.menuitemServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSTToolGUI.this.menuitemServerPerformed(evt);
            }
        });
        this.menuitemClient = new JMenuItem();
        this.menuitemClient.setText(this.mainBase.getLanguageEntryPersonal("MENU_CLIENT"));
        this.menuitemClient.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SSTToolGUI.this.menuitemClientPerformed(evt);
            }
        });
        this.getMenuFile().add(this.menuitemServer);
        this.getMenuFile().add(this.menuitemClient);
        this.getMenuFile().add(this.getFileSeparator());
        this.getMenuFile().add(this.getMenuItemFileExit());
    }

    @Override
    public MainBase getMainBase() {
        if (this.mainBase == null) {
            this.mainBase = new SSTToolMainBase();
        }
        return this.mainBase;
    }

    private void menuitemServerPerformed(ActionEvent evt) {
        String PREOUTTEXT = "menuitemServerPerformed";
        if (!this.getMainBase().isShowingFrame(ServerFrame.class.getName())) {
            try {
                this.frameServer = new ServerFrame(this);
                this.frameServer.setVisible(true);
                this.getMainBase().addFrame(this.frameServer, false);
                this.addOutputTextDetailed("menuitemServerPerformed created the internal Frame <" + ServerFrame.class.getName() + ">");
                this.getMainBase().debug("menuitemServerPerformed created the internal Frame <" + ServerFrame.class.getName() + ">");
            }
            catch (PropertyVetoException ex) {
                this.getMainBase().getLogFile().err2File(ex, "menuitemServerPerformed");
            }
        } else {
            this.addOutputTextDetailed("menuitemServerPerformed internal frame <" + ServerFrame.class.getName() + "> already opened");
            this.getMainBase().debug("menuitemServerPerformed internal frame <" + ServerFrame.class.getName() + "> already opened");
        }
    }

    private void menuitemClientPerformed(ActionEvent evt) {
        String PREOUTTEXT = "menuitemClientPerformed";
        if (!this.getMainBase().isShowingFrame(ClientFrame.class.getName())) {
            try {
                this.frameClient = new ClientFrame(this);
                this.frameClient.setVisible(true);
                this.getMainBase().addFrame(this.frameClient, false);
                this.addOutputTextDetailed("menuitemClientPerformed created the internal Frame <" + ClientFrame.class.getName() + ">");
                this.getMainBase().debug("menuitemClientPerformed created the internal Frame <" + ClientFrame.class.getName() + ">");
            }
            catch (PropertyVetoException ex) {
                this.getMainBase().getLogFile().err2File(ex, "menuitemClientPerformed");
            }
        } else {
            this.addOutputTextDetailed("menuitemClientPerformed internal frame <" + ClientFrame.class.getName() + "> already opened");
            this.getMainBase().debug("menuitemClientPerformed internal frame <" + ClientFrame.class.getName() + "> already opened");
        }
    }

    private void menuitemAddDBConnectionPerformed(ActionEvent evt) {
        String PREOUTTEXT = "menuitemAddDBConnectionPerformed";
        this.getMainBase().debug("Add DB Connection clicked", "menuitemAddDBConnectionPerformed");
        this.addDBConnection = new DialogAddDBConnection((Frame)this, true, "COA");
        this.addDBConnection.setVisible(true);
    }

    private JSeparator getFileSeparator() {
        if (this.menuItemFileSeparator == null) {
            this.menuItemFileSeparator = new JSeparator();
        }
        return this.menuItemFileSeparator;
    }

    private JSeparator getFileSeparator2() {
        if (this.menuItemFileSeparator2 == null) {
            this.menuItemFileSeparator2 = new JSeparator();
        }
        return this.menuItemFileSeparator2;
    }
}

