/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.gui.jdialogs;

import at.glawar.gladataadapter.GLAMySQLDataAdapter;
import at.glawar.gladataadapter.GLAOracleDataAdapter;
import at.glawar.interfaces.IGDataAdapter;
import at.glawar.javaframework.gui.base.BaseJDialog;
import at.glawar.ssttool.SSTToolMainBase;
import at.glawar.ssttool.exceptions.ExAlreadyConnected;
import at.glawar.ssttool.gui.SSTToolGUI;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class DialogAddDBConnection
extends BaseJDialog {
    private boolean configurationChanged = false;
    private String dbType = "";
    private Object[][] dbParams = null;
    private String[] columnNames = new String[]{"parameter", "value"};
    private SSTToolMainBase mainBaseSST = (SSTToolMainBase)this.mainGui.getMainBase();
    private JComboBox availableDatabases;
    private JButton buttonAddDBConnection;
    private JButton buttonClose;
    private JButton buttonHelp;
    private JButton buttonSaveAndClose;
    private JButton buttonTestConnection;
    private JScrollPane jScrollPane1;
    private JScrollPane panelScroll;
    private JTable tableDBParams;
    private JTextArea textAreaOutout;

    public DialogAddDBConnection(Frame parent, boolean modal, String alignment) {
        super(parent, modal, alignment);
        this.initComponents();
        this.setTitle(this.mainBase.getLanguageEntryPersonal("TEXT_ADD_NEW_DB_CONNECTION"));
        this.availableDatabases.setModel(new DefaultComboBoxModel<String>(new String[]{"MySQL", "Oracle"}));
        this.buttonAddDBConnection.setText(this.mainBase.getLanguageEntryPersonal("BUTTON_ADD"));
        this.buttonTestConnection.setText(this.mainBase.getLanguageEntryPersonal("BUTTON_TEST_CONNECTION"));
        this.buttonSaveAndClose.setText(this.mainBase.getLanguageEntryPersonal("BUTTON_SAVE_CLOSE"));
        this.buttonClose.setText(this.mainBase.getLanguageEntryPersonal("BUTTON_CLOSE"));
        this.buttonHelp.setText(this.mainBase.getLanguageEntryPersonal("BUTTON_HELP"));
        SSTToolGUI sstGui = (SSTToolGUI)parent;
        sstGui.getHelpBroker().enableHelpOnButton((Component)this.buttonHelp, "NEWDBCONNECTION", sstGui.getHelpSet());
        this.alignDialog();
    }

    private void saveConfig() {
        int i;
        int numRows = this.tableDBParams.getRowCount();
        TableModel model = this.tableDBParams.getModel();
        String sectionName = "";
        for (i = 0; i < numRows; ++i) {
            if ("NameOfDB".compareTo((String)model.getValueAt(i, 0)) != 0) continue;
            sectionName = (String)model.getValueAt(i, 1);
        }
        this.mainBaseSST.getConfigFile().setConfigFileValue(sectionName, "databasetyp", this.dbType);
        for (i = 0; i < numRows; ++i) {
            if ("NameOfDB".compareTo((String)model.getValueAt(i, 0)) == 0) continue;
            this.mainBaseSST.getConfigFile().setConfigFileValue(sectionName, (String)model.getValueAt(i, 0), (String)model.getValueAt(i, 1));
        }
        try {
            this.mainBaseSST.getConfigFile().storeConfigFile();
        }
        catch (IOException ex) {
            this.mainGui.addOutputText(this.mainBase.getLanguageEntryPersonal("ERROR_CONFIG_NOT_SAVED"));
            this.mainBaseSST.getLogFile().log2File(ex);
        }
    }

    private void closeMe() {
        if (this.configurationChanged) {
            int n = JOptionPane.showConfirmDialog(this, this.mainBase.getLanguageEntryPersonal("COMM_SAVE"), this.mainBase.getLanguageEntryPersonal("TITLE_SAVING"), 0);
            if (n == 1) {
                this.dispose();
            } else if (n == 0) {
                this.saveConfig();
                this.dispose();
            }
        }
        this.dispose();
    }

    @Override
    protected void formWindowClosing(WindowEvent evt) {
        this.closeMe();
    }

    private void createDefaultOracleParameters() {
        this.dbParams = new Object[18][2];
        this.dbParams[0][0] = "NameOfDB";
        this.dbParams[0][1] = "My DatabaseName";
        this.dbParams[1][0] = "user";
        this.dbParams[1][1] = "SYS";
        this.dbParams[2][0] = "password";
        this.dbParams[2][1] = "SYS";
        this.dbParams[3][0] = "database";
        this.dbParams[3][1] = "XID";
        this.dbParams[4][0] = "server";
        this.dbParams[4][1] = "localhost";
        this.dbParams[5][0] = "dbbort";
        this.dbParams[5][1] = "1521";
        this.dbParams[6][0] = "SelectTypes";
        this.dbParams[6][1] = "select distinct tabname from import order by tabname";
        this.dbParams[7][0] = "SelectTelegram";
        this.dbParams[7][1] = "select rc, colname, laenge, numerical, dezimal from import where tabname = 'TELEGRAMTYPE' order by rc";
        this.dbParams[8][0] = "TelegramDelimiter";
        this.dbParams[8][1] = "";
        this.dbParams[9][0] = "ServerPort";
        this.dbParams[9][1] = "2000";
        this.dbParams[10][0] = "ServerReplyText";
        this.dbParams[10][1] = "RE_";
        this.dbParams[11][0] = "ServerAutomaticReply";
        this.dbParams[11][1] = "1";
        this.dbParams[12][0] = "ServerTerminator";
        this.dbParams[12][1] = "cr";
        this.dbParams[13][0] = "ServerWatchdog";
        this.dbParams[13][1] = "WATCHDOG_HOST";
        this.dbParams[14][0] = "ClientTerminator";
        this.dbParams[14][1] = "lf";
        this.dbParams[15][0] = "SocketServer";
        this.dbParams[15][1] = "192.168.1.105";
        this.dbParams[16][0] = "ClientPort";
        this.dbParams[16][1] = "2001";
        this.dbParams[17][0] = "ServerWatchdogTimer";
        this.dbParams[17][1] = "50";
    }

    private void createDefaultMySQLParameters() {
        this.dbParams = new Object[18][2];
        this.dbParams[0][0] = "NameOfDB";
        this.dbParams[0][1] = "My DatabaseName";
        this.dbParams[1][0] = "server";
        this.dbParams[1][1] = "localhost";
        this.dbParams[2][0] = "port";
        this.dbParams[2][1] = "3306";
        this.dbParams[3][0] = "database";
        this.dbParams[3][1] = "test";
        this.dbParams[4][0] = "user";
        this.dbParams[4][1] = "root";
        this.dbParams[5][0] = "password";
        this.dbParams[5][1] = "root";
        this.dbParams[6][0] = "SelectTypes";
        this.dbParams[6][1] = "select distinct tabname from import order by tabname";
        this.dbParams[7][0] = "SelectTelegram";
        this.dbParams[7][1] = "select rc, colname, laenge, numerical, dezimal from import where tabname = 'TELEGRAMTYPE' order by rc";
        this.dbParams[8][0] = "TelegramDelimiter";
        this.dbParams[8][1] = "";
        this.dbParams[9][0] = "ServerPort";
        this.dbParams[9][1] = "2000";
        this.dbParams[10][0] = "ServerReplyText";
        this.dbParams[10][1] = "RE_";
        this.dbParams[11][0] = "ServerAutomaticReply";
        this.dbParams[11][1] = "1";
        this.dbParams[12][0] = "ServerTerminator";
        this.dbParams[12][1] = "cr";
        this.dbParams[13][0] = "ServerWatchdog";
        this.dbParams[13][1] = "WATCHDOG_HOST";
        this.dbParams[14][0] = "ClientTerminator";
        this.dbParams[14][1] = "lf";
        this.dbParams[15][0] = "SocketServer";
        this.dbParams[15][1] = "192.168.1.105";
        this.dbParams[16][0] = "ClientPort";
        this.dbParams[16][1] = "2001";
        this.dbParams[17][0] = "ServerWatchdogTimer";
        this.dbParams[17][1] = "50";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDBConnectionMySQL(Properties props) {
        Connection conn = null;
        String strMetaData = null;
        String output = null;
        try {
            if (this.mainBaseSST.getDataAdapter() != null) {
                this.mainGui.addOutputText(this.mainBase.getLanguageEntryPersonal("INFO_ALREADY_CONNECTED"));
                throw new ExAlreadyConnected("already connected");
            }
            this.mainBaseSST.setDataAdapter((IGDataAdapter)new GLAMySQLDataAdapter(props));
            conn = this.mainBaseSST.getDataAdapter().getConnection();
            strMetaData = this.mainBaseSST.getDataAdapter().getMetaDataInformation(conn);
            output = this.mainBase.getLanguageEntryPersonal("TEST_CONNECTION_SUCC");
            this.textAreaOutout.setText(output);
            if (strMetaData != null && strMetaData.length() > 0) {
                output = output + " Here are a few meta-information of your database:\n\r";
                output = output + strMetaData;
            }
            this.mainGui.addOutputText(output);
        }
        catch (ExAlreadyConnected exa_nothing) {
        }
        catch (Exception ex) {
            this.textAreaOutout.setText(this.mainBase.getLanguageEntryPersonal("ERROR_CONNECTION"));
            this.mainBase.getLogFile().log2File(ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                    conn = null;
                }
                catch (SQLException ex_nothing) {}
            }
            this.mainBaseSST.setDataAdapter(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDBConnectionOracle(Properties props) {
        Connection conn = null;
        String strMetaData = null;
        String output = null;
        try {
            if (this.mainBaseSST.getDataAdapter() != null) {
                this.mainGui.addOutputText(this.mainBase.getLanguageEntryPersonal("INFO_ALREADY_CONNECTED"));
                throw new ExAlreadyConnected("already connected");
            }
            this.mainBaseSST.setDataAdapter((IGDataAdapter)new GLAOracleDataAdapter(props));
            conn = this.mainBaseSST.getDataAdapter().getConnection();
            GLAOracleDataAdapter goDataAdapter = (GLAOracleDataAdapter)this.mainBaseSST.getDataAdapter();
            strMetaData = this.mainBaseSST.getDataAdapter().getMetaDataInformation(conn);
            output = this.mainBase.getLanguageEntryPersonal("TEST_CONNECTION_SUCC");
            this.textAreaOutout.setText(output);
            if (strMetaData != null && strMetaData.length() > 0) {
                output = output + " Here are a few meta-information of your database:\n\r";
                output = output + strMetaData;
            }
            this.mainGui.addOutputText(output);
        }
        catch (ExAlreadyConnected exa_nothing) {
        }
        catch (Exception ex) {
            this.mainBaseSST.setDataAdapter(null);
            this.textAreaOutout.setText(this.mainBase.getLanguageEntryPersonal("ERROR_CONNECTION"));
            this.mainBase.getLogFile().log2File(ex);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                    conn = null;
                }
                catch (SQLException ex_nothing) {}
            }
            this.mainBaseSST.setDataAdapter(null);
        }
    }

    private void initComponents() {
        this.availableDatabases = new JComboBox();
        this.buttonAddDBConnection = new JButton();
        this.buttonTestConnection = new JButton();
        this.buttonSaveAndClose = new JButton();
        this.buttonClose = new JButton();
        this.panelScroll = new JScrollPane();
        this.tableDBParams = new JTable();
        this.jScrollPane1 = new JScrollPane();
        this.textAreaOutout = new JTextArea();
        this.buttonHelp = new JButton();
        this.setDefaultCloseOperation(0);
        this.availableDatabases.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.buttonAddDBConnection.setText("Add");
        this.buttonAddDBConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonAddDBConnectionActionPerformed(evt);
            }
        });
        this.buttonTestConnection.setText("Test Connection");
        this.buttonTestConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonTestConnectionActionPerformed(evt);
            }
        });
        this.buttonSaveAndClose.setText("Save and Close");
        this.buttonSaveAndClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonSaveAndCloseActionPerformed(evt);
            }
        });
        this.buttonClose.setText("Close");
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DialogAddDBConnection.this.buttonCloseActionPerformed(evt);
            }
        });
        this.tableDBParams.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"parameter", "value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.panelScroll.setViewportView(this.tableDBParams);
        this.textAreaOutout.setColumns(20);
        this.textAreaOutout.setRows(5);
        this.jScrollPane1.setViewportView(this.textAreaOutout);
        this.buttonHelp.setText("jButton1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelScroll).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.availableDatabases, -2, 137, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonHelp, -1, 95, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonAddDBConnection, -2, 105, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonTestConnection, -2, 155, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSaveAndClose, -2, 188, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonClose, -1, 139, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.availableDatabases, -2, -1, -2).addComponent(this.buttonAddDBConnection).addComponent(this.buttonTestConnection).addComponent(this.buttonSaveAndClose).addComponent(this.buttonClose).addComponent(this.buttonHelp)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelScroll, -1, 293, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 57, -2).addContainerGap()));
        this.pack();
    }

    private void buttonAddDBConnectionActionPerformed(ActionEvent evt) {
        String PRETEXT = "DialogAddDBConnection.buttonAddDBConnectionActionPerformed";
        this.mainBaseSST.debug("Add clicked");
        this.configurationChanged = true;
        int index = this.availableDatabases.getSelectedIndex();
        this.mainBase.debug("Database <" + (String)this.availableDatabases.getItemAt(index) + ">", "DialogAddDBConnection.buttonAddDBConnectionActionPerformed");
        if ("Oracle".compareTo((String)this.availableDatabases.getItemAt(index)) == 0) {
            this.dbType = "Oracle";
            this.createDefaultOracleParameters();
        } else if ("MySQL".compareTo((String)this.availableDatabases.getItemAt(index)) == 0) {
            this.dbType = "MySQL";
            this.createDefaultMySQLParameters();
        } else {
            this.mainGui.addOutputText("<" + (String)this.availableDatabases.getItemAt(index) + "> not supported yet");
        }
        this.tableDBParams = new JTable();
        this.tableDBParams.setModel(new DefaultTableModel(this.dbParams, this.columnNames){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.tableDBParams.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                DialogAddDBConnection.this.configurationChanged = true;
            }
        });
        this.panelScroll.setViewportView(this.tableDBParams);
    }

    private void buttonTestConnectionActionPerformed(ActionEvent evt) {
        Properties props = new Properties();
        int numRows = this.tableDBParams.getRowCount();
        String param = null;
        TableModel model = this.tableDBParams.getModel();
        for (int i = 0; i < numRows; ++i) {
            param = (String)model.getValueAt(i, 0);
            if ("My DatabaseName".compareTo(param) == 0) continue;
            props.setProperty(param, (String)model.getValueAt(i, 1));
        }
        int index = this.availableDatabases.getSelectedIndex();
        if ("Oracle".compareTo((String)this.availableDatabases.getItemAt(index)) == 0) {
            this.testDBConnectionOracle(props);
        } else if ("MySQL".compareTo((String)this.availableDatabases.getItemAt(index)) == 0) {
            this.testDBConnectionMySQL(props);
        } else {
            this.mainGui.addOutputText("<" + (String)this.availableDatabases.getItemAt(index) + "> is no valid Database");
        }
    }

    private void buttonSaveAndCloseActionPerformed(ActionEvent evt) {
        this.saveConfig();
        this.dispose();
    }

    private void buttonCloseActionPerformed(ActionEvent evt) {
        this.closeMe();
    }
}

