/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.test;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class TestClient
extends Thread {
    private final String ME = "CLIENT: ";
    private String host = null;
    private int port = 2001;
    private String serverTerminator = "";
    private String clientTerminator = "";
    private boolean goOn = true;
    private final Object lock = new Object();
    private Socket server;
    private boolean isRunning = false;
    private DataInputStream inputFromServer = null;
    private DataOutputStream output4Server = null;
    private boolean withResponse = false;
    private ArrayList responses = new ArrayList();
    private String lastMessageSent = null;

    public static void main(String[] args) {
        TestClient testClient = new TestClient("10.12.3.171", 2000, false);
        testClient.setServerTerminator("cr");
        testClient.setClientTerminator("cr");
        testClient.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        try {
            testClient.sendMessage2Server("Franz");
            testClient.sendMessage2Server("Peter");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        try {
            testClient.sendMessage2Server("Hugo 1");
            testClient.sendMessage2Server("Peterle 2");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
    }

    public TestClient(String host, int port, boolean withResponse) {
        this.host = host;
        this.port = port;
        this.withResponse = withResponse;
    }

    public void setServerTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\n";
        }
    }

    public void setClientTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\n";
        }
    }

    private Socket getServer() throws IOException {
        if (this.server == null) {
            this.server = new Socket(this.host, this.port);
            System.out.println("CLIENT: Socket to server created (if)");
        } else if (!this.server.isConnected()) {
            System.out.println("CLIENT: Socket to server not connected");
            this.server = new Socket(this.host, this.port);
            System.out.println("CLIENT: Socket to server created (else)");
        }
        return this.server;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private DataInputStream getInputStreamFromServer() throws IOException {
        if (this.inputFromServer == null) {
            this.inputFromServer = new DataInputStream(this.getServer().getInputStream());
        }
        return this.inputFromServer;
    }

    private String getTelegram(String msg) {
        int i;
        if (msg != null && (i = msg.indexOf(this.serverTerminator)) > 0) {
            return msg.substring(0, i).trim();
        }
        return "";
    }

    private DataOutputStream getOutputStream4Server() {
        if (this.output4Server == null) {
            try {
                this.output4Server = new DataOutputStream(this.getServer().getOutputStream());
                this.output4Server.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.output4Server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("CLIENT: Starting client ...");
        this.goOn = true;
        try {
            int amountOfReadCharacters = 0;
            while (this.isGoOn()) {
                if (amountOfReadCharacters != -1) {
                    this.isRunning = true;
                    StringBuffer buffer = new StringBuffer();
                    amountOfReadCharacters = this.getInputStreamFromServer().read();
                    while (this.serverTerminator != null && amountOfReadCharacters >= 0 && buffer.append((char)amountOfReadCharacters).toString().indexOf(this.serverTerminator) < 0) {
                        amountOfReadCharacters = this.getInputStreamFromServer().read();
                    }
                    String telegram = buffer.toString();
                    if ((telegram = this.getTelegram(telegram)).length() <= 0) continue;
                    System.out.println("CLIENT: Message received from server <" + telegram + ">");
                    this.responses.add(telegram);
                    continue;
                }
                System.out.println("CLIENT: Server is down");
                this.stopClient();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        finally {
            this.tryClosing();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.goOn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopClient() {
        Object object = this.lock;
        synchronized (object) {
            System.out.println("CLIENT: We are stopping now ...");
            this.goOn = false;
            this.tryClosing();
        }
    }

    private void tryClosing() {
        try {
            if (this.inputFromServer != null) {
                this.inputFromServer.close();
                this.inputFromServer = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getPreText4Response() {
        return "RE_";
    }

    public String getAfterText4Response() {
        return "";
    }

    private boolean gotResponse4Message(String message) {
        boolean retVal = false;
        String tempMessage = this.getPreText4Response() + message + this.getAfterText4Response();
        retVal = this.responses.contains(tempMessage);
        this.responses.remove(tempMessage);
        return retVal;
    }

    public void sendMessage2Server(String message) throws IOException {
        if (this.withResponse && this.lastMessageSent != null) {
            while (!this.gotResponse4Message(this.lastMessageSent)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        System.out.println("CLIENT: Sending to server <" + message + ">");
        this.getOutputStream4Server().writeBytes(message + this.clientTerminator);
        this.getOutputStream4Server().flush();
        this.lastMessageSent = message;
    }
}

