/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.files;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyFile {
    private File propertyFile = null;
    private Properties props = new Properties();

    public PropertyFile() {
    }

    public PropertyFile(String fullName) {
        this.propertyFile = new File(fullName);
    }

    public PropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setPropertyFile(String fullName) {
        this.propertyFile = new File(fullName);
    }

    public void setPropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
    }

    public void setProperty(String key, String value) {
        this.props.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public void loadProperties() throws FileNotFoundException, IOException {
        FileInputStream propFile = null;
        propFile = new FileInputStream(this.propertyFile);
        this.props.load(propFile);
        propFile.close();
    }

    public void printAllProperties() {
        this.printAllProperties(System.out);
    }

    public void printAllProperties(PrintStream ps) {
        Enumeration<Object> em = this.props.keys();
        while (em.hasMoreElements()) {
            String str = (String)em.nextElement();
            ps.println(str + ": " + this.props.get(str));
        }
    }

    public void saveProperties() throws FileNotFoundException, IOException {
        this.saveProperties(null);
    }

    public void saveProperties(String text) throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        out = new FileOutputStream(this.propertyFile);
        this.props.store(out, text);
        out.close();
    }
}

