/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.utils;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class Images {
    private Images() {
    }

    public static BufferedImage resizeAbsolute(BufferedImage inputImage, int newWidth, int newHeight) {
        int w = inputImage.getWidth();
        int h = inputImage.getHeight();
        BufferedImage dimg = new BufferedImage(newWidth, newHeight, inputImage.getType());
        Graphics2D g = dimg.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(inputImage, 0, 0, newWidth, newHeight, 0, 0, w, h, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage resize2MaxValues(BufferedImage inputImage, int maxWidth, int maxHeight) {
        BufferedImage retVal = null;
        int width = inputImage.getWidth();
        int height = inputImage.getHeight();
        double diff = width / height;
        int newValue = (int)((double)maxHeight * diff);
        BufferedImage tempImage = new BufferedImage(newValue, maxHeight, inputImage.getType());
        Graphics2D g = tempImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(inputImage, 0, 0, newValue, maxHeight, 0, 0, width, height, null);
        g.dispose();
        width = tempImage.getWidth();
        height = tempImage.getHeight();
        diff = width / height;
        newValue = (int)((double)maxWidth / diff);
        if (width > maxWidth) {
            retVal = new BufferedImage(maxWidth, newValue, tempImage.getType());
            g = retVal.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(tempImage, 0, 0, maxWidth, newValue, 0, 0, width, height, null);
            g.dispose();
        } else {
            retVal = tempImage;
        }
        return retVal;
    }
}

