/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtils {
    private static final int BUFFER_SIZE = 4096;

    private ZipUtils() {
    }

    private static void extractFile(ZipInputStream in, File outdir, String name) throws IOException {
        byte[] buffer = new byte[4096];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        int count = -1;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private static void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    private static String dirpart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }

    public static void extract(String zipfile, String outdir) throws FileNotFoundException, IOException {
        File zipFile = new File(zipfile);
        File outFile = new File(outdir);
        ZipUtils.extract(zipFile, outFile);
    }

    public static void extract(File zipfile, File outdir) throws FileNotFoundException, IOException {
        ZipInputStream zin = new ZipInputStream(new FileInputStream(zipfile));
        try {
            ZipEntry entry;
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    ZipUtils.mkdirs(outdir, name);
                    continue;
                }
                String dir = ZipUtils.dirpart(name);
                if (dir != null) {
                    ZipUtils.mkdirs(outdir, dir);
                }
                ZipUtils.extractFile(zin, outdir, name);
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            zin.close();
        }
    }
}

