@echo off
rem Authors: Franz-Peter Glawar <office@glawar.at>, 2013
rem This script will install/uninstall TestSomething
rem (c) www.glawar.at
rem ######################################################################
rem ####  History
rem 2013-11-18 FPG created the script
rem 2013-12-06 FPG adapted the script for actual version
rem 2013-12-17 FPG adatped the script for SSTTool
rem 2013-12-21 FPG added help file
rem ######################################################################
rem ####  Variables that should be adapted if necessary
set INSTALLDIR=C:\Programme\glawar.at\Java
rem ######################################################################
rem ####  Variables that should not be changed
set PROGRAM=SSTTool
set REVISION=363
set WINDOWSDIR=C:\Windows
set LOGDIR=C:\log\glawar.at
rem ####  Exit-values
set EXIT_OK=0
set EXIT_WRONG_PARAMETERS_GIVEN=1
set EXIT_NO_ROOT=2
set EXIT_NO_DIR=3
set EXIT_ABORT_BY_USER=4
rem ######################################################################


rem createStartScript
if not exist %INSTALLDIR%\%PROGRAM%\nul goto CREATEFIRST
goto CREATEFIRSTDONE

:CREATEFIRST
    mkdir %INSTALLDIR%\%PROGRAM%
:CREATEFIRSTDONE
echo "Copy %PROGRAM%.cmd to %WINDOWSDIR%"
copy %PROGRAM%.cmd %WINDOWSDIR%


rem installGlobalLib
if not exist %INSTALLDIR%\lib\glawar.at\nul goto CREATESECOND
goto CREATESECONDDONE

:CREATESECOND
    mkdir %INSTALLDIR%\lib\glawar.at

:CREATESECONDDONE
echo "copy lib\lib\ini4j-0.5.1.jar to %INSTALLDIR%\lib"
copy lib\lib\ini4j-0.5.1.jar %INSTALLDIR%\lib

echo "copy lib\lib\jh.jar to %INSTALLDIR%\lib"
copy lib\lib\jh.jar %INSTALLDIR%\lib

echo "copy lib\lib\mysql-connector-java-3.1.12-bin.jar to %INSTALLDIR%\lib"
copy lib\lib\mysql-connector-java-3.1.12-bin.jar %INSTALLDIR%\lib

echo "copy lib\lib\ojdbc14.jar to %INSTALLDIR%\lib"
copy lib\lib\ojdbc14.jar %INSTALLDIR%\lib

IF NOT EXIST %INSTALLDIR%\lib\glawar.at\JavaFramework.jar GOTO NOJAVAFRAMEWORK
echo "JavaFramework existiert"
rem for /f %%a in ('java -jar %INSTALLDIR%\lib\JavaFramework.jar revision') do set RETVAL=%%a
for /f %%a in ('java -cp "%INSTALLDIR%\lib\glawar.at\JavaFramework.jar" at.glawar.revision.Revision') do set RETVAL=%%a
rem echo "RETVAL ist %RETVAL%"

if %REVISION% gtr %RETVAL% goto NOJAVAFRAMEWORK
goto JAVAFRAMEWORKREADY

:NOJAVAFRAMEWORK
    echo "JavaFramework existiert NICHT oder muss aktualisiert werden"
    echo "copy lib\lib\JavaFramework.jar to %INSTALLDIR%\lib\glawar.at"
    copy lib\lib\JavaFramework.jar %INSTALLDIR%\lib\glawar.at
    goto JAVAFRAMEWORKREADY
    
:JAVAFRAMEWORKREADY

echo "copy lib\lib\dataadapter.jar to %INSTALLDIR%\lib\glawar.at"
copy lib\lib\dataadapter.jar %INSTALLDIR%\lib\glawar.at


rem installProgram
if not exist %INSTALLDIR%\lib\nul goto CREATETHIRD
goto CREATETHIRDDONE

:CREATETHIRD
    mkdir %INSTALLDIR%\%PROGRAM%\lib
    
:CREATETHIRDDONE
echo "copy lib\%PROGRAM%.jar to %INSTALLDIR%\%PROGRAM%"
copy lib\%PROGRAM%.jar %INSTALLDIR%\%PROGRAM%

echo "copy lib\lib\JavaHelp.jar to %INSTALLDIR%\%PROGRAM%"
copy lib\lib\JavaHelp.jar %INSTALLDIR%\%PROGRAM%

rem create log directory
if not exist %LOGDIR%\%PROGRAM%\nul goto CREATEFORTH
goto CREATEFORTHDONE

:CREATEFORTH
    mkdir %LOGDIR%\%PROGRAM%
:CREATEFORTHDONE

exit /B %EXIT_OK%
