#!/bin/sh
#
# Authors: Franz-Peter Glawar <office@glawar.at>, 2013
#
# This script will install/uninstall ManageExif
#
# (c) www.glawar.at
#
######################################################################
####  History
#---------------------------------------------------------------------
# 2013-11-18 FPG created the script
# 2013-11-23 FPG adapted the script because before JavaFramework
#                will be copied the version will be checked
# 2013-12-06 FPG adapted the script for the new version which has now
#                another external library
# 2013-12-08 FPG adapted permission in java-directories so that an update
#                can be done
# 2013-12-17 FPG adapted script for SSTTool
# 2013-12-21 FPG added help file
######################################################################
####  Variables that should be adapted if necessary
####------------------------------------------------------------------
INSTALLDIR=/opt/glawar.at/java
BINDIR=/usr/local/bin
LOGDIR=/var/log/glawar.at
######################################################################
####  Variables that should not be changed
####------------------------------------------------------------------
PROGRAM=SSTTool
REVISION=363
####  Exit-values
EXIT_OK=0
EXIT_WRONG_PARAMETERS_GIVEN=1
EXIT_NO_ROOT=2
EXIT_NO_DIR=3
EXIT_ABORT_BY_USER=4
######################################################################


main () {
    isRoot
    
    createStartScript
    installGlobalLib
    installProgram
    createLinks
    createUninstallScript
    
    exit ${EXIT_OK}
}


#---------------------------------------------------------------------
# (c) www.glawar.at: checks if user is root,
#
# otherwise exits with ${EXIT_NO_ROOT}; if cygwin is used
# no root-user exists --> check for root-user not necessary
#---------------------------------------------------------------------
isRoot() {
  CYGWIN=false
  if [ -d /cygdrive ]; then
    CYGWIN=true
  fi

  if ! ${CYGWIN} ; then
    # no cygwin used --> check if user is root
    if [ ! "`id -u`" -eq 0 ]; then
      # user must bee root
      echo "Sorry, but you must be root to install/uninstall \"${PROGRAM}\"!"
      echo
      exit ${EXIT_NO_ROOT}
    fi
  fi
}


#---------------------------------------------------------------------
# (c) www.glawar.at: creates the start script for starting java
#                    application
#---------------------------------------------------------------------
createStartScript () {
    mkdir -p ${INSTALLDIR}/${PROGRAM}
    echo "#!/bin/sh" > ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh
    echo "cd ${INSTALLDIR}/${PROGRAM}" >> ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh
    #echo "#java -cp "../lib/JavaFramework.jar:../lib/ini4j-0.5.1.jar" at.glawar.javaframework.MainCommand" >> ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh
    echo "java -cp \"/opt/glawar.at/java/SSTTool/SSTTool.jar:/opt/glawar.at/java/SSTTool/JavaHelp.jar:/opt/glawar.at/java/lib/glawar.at/JavaFramework.jar:/opt/glawar.at/java/lib/glawar.at/dataadapter.jar:/opt/glawar.at/java/lib/ini4j-0.5.1.jar:/opt/glawar.at/java/lib/jh.jar:/opt/glawar.at/java/lib/mysql-connector-java-3.1.12-bin.jar:/opt/glawar.at/java/lib/ojdbc14.jar\" at.glawar.ssttool.gui.SSTToolGUI debugmodus" >> ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh
    
    chmod +x ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh
    
    echo "Startscript ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh created"
}


#---------------------------------------------------------------------
# (c) www.glawar.at: installs global java libraries
#---------------------------------------------------------------------
installGlobalLib () {
    mkdir -p ${INSTALLDIR}/lib

    cp lib/lib/ini4j-0.5.1.jar ${INSTALLDIR}/lib
    
    cp lib/lib/jh.jar ${INSTALLDIR}/lib
    
    cp lib/lib/mysql-connector-java-3.1.12-bin.jar ${INSTALLDIR}/lib
    
    cp lib/lib/ojdbc14.jar ${INSTALLDIR}/lib
    
    

    mkdir -p ${INSTALLDIR}/lib/glawar.at

    if [ -f ${INSTALLDIR}/lib/glawar.at/JavaFramework.jar ]; then
        echo "${INSTALLDIR}/lib/glawar.at/JavaFramework.jar already exists"
        ACTUALREVISION=`java -cp "${INSTALLDIR}/lib/glawar.at/JavaFramework.jar" at.glawar.revision.Revision`
        if [ ${ACTUALREVISION} -lt ${REVISION} ]; then
            echo "Actual Revision ${ACTUALREVISION} is not enough (${REVISION})"
            echo "So we will update it"
            cp lib/lib/JavaFramework.jar ${INSTALLDIR}/lib/glawar.at
        else
            echo "Actual Revision ${ACTUALREVISION} is enough (min. ${REVISION})"
        fi
    else
        echo "${INSTALLDIR}/lib/glawar.at/JavaFramework.jar does not exist"
        cp lib/lib/JavaFramework.jar ${INSTALLDIR}/lib/glawar.at
    fi
    
    cp lib/lib/dataadapter.jar ${INSTALLDIR}/lib/glawar.at
    
    # 2013-12-08: permission changed
    chmod -R g+w,u+w,o+w ${INSTALLDIR}/lib
}


#---------------------------------------------------------------------
# (c) www.glawar.at: installs libraries necessary for the program
#---------------------------------------------------------------------
installProgram () {
    mkdir -p ${INSTALLDIR}/${PROGRAM}
    cp lib/${PROGRAM}.jar ${INSTALLDIR}/${PROGRAM}
    
    cp lib/lib/JavaHelp.jar ${INSTALLDIR}/${PROGRAM}
    
    mkdir -p ${LOGDIR}/${PROGRAM}
    chmod -R g+w,u+w,o+w ${LOGDIR}/${PROGRAM}

    echo "Program ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.jar installed and log-directory ${LOGDIR}/${PROGRAM} created"

    # 2013-12-08: changed permission
    chmod -R g+w,u+w,o+w ${INSTALLDIR}/${PROGRAM}
}


#---------------------------------------------------------------------
# (c) www.glawar.at: create necessary links to start the program
#---------------------------------------------------------------------
createLinks () {
    ln -sf ${INSTALLDIR}/${PROGRAM}/${PROGRAM}.sh ${BINDIR}

    echo "symbolic link created in ${BINDIR}"
}


#---------------------------------------------------------------------
# (c) www.glawar.at: creates an uninstall script
#---------------------------------------------------------------------
createUninstallScript () {
    echo "#!/bin/sh" > ${INSTALLDIR}/${PROGRAM}/uninstall${PROGRAM}.sh
    echo "rm ${BINDIR}/${PROGRAM}.sh" >> ${INSTALLDIR}/${PROGRAM}/uninstall${PROGRAM}.sh
    echo "rm -r ${INSTALLDIR}/${PROGRAM}" >> ${INSTALLDIR}/${PROGRAM}/uninstall${PROGRAM}.sh
    echo "exit 0" >> ${INSTALLDIR}/${PROGRAM}/uninstall${PROGRAM}.sh
    
    chmod +x ${INSTALLDIR}/${PROGRAM}/uninstall${PROGRAM}.sh

    echo "Uninstall script created ${INSTALLDIR}/${PROGRAM}/uninstall${PROGRAM}.sh"
}



main ${*}
