/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.gui.table.celleditor;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;

public class FormatNumberEditor
extends DefaultCellEditor {
    DecimalFormat numberFormat;

    public FormatNumberEditor(DecimalFormat numberFormat) {
        super(new JFormattedTextField(numberFormat));
        this.numberFormat = numberFormat;
        this.getEditor().setHorizontalAlignment(4);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object param) {
                Number _value = (Number)param;
                if (_value == null) {
                    FormatNumberEditor.this.getEditor().setText(FormatNumberEditor.this.numberFormat.format(0.0));
                } else {
                    double _d = _value.doubleValue();
                    String _format = FormatNumberEditor.this.numberFormat.format(_d);
                    FormatNumberEditor.this.getEditor().setText(_format);
                }
            }

            @Override
            public Object getCellEditorValue() {
                try {
                    String _field = FormatNumberEditor.this.getEditor().getText();
                    return FormatNumberEditor.this.numberFormat.parse(_field);
                }
                catch (ParseException ex) {
                    Logger.getLogger(FormatNumberEditor.class.getName()).log(Level.SEVERE, null, ex);
                    return null;
                }
            }
        };
    }

    public JTextField getEditor() {
        return (JFormattedTextField)this.getComponent();
    }
}

