/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.utils;

import at.glawar.javaframework.exceptions.JFBaseException;
import at.glawar.javaframework.exceptions.JFNoVersionException;
import at.glawar.javaframework.exceptions.JFVersionNegativException;
import at.glawar.javaframework.exceptions.JFWrongVersionException;
import java.util.StringTokenizer;

public class VersionObject {
    private int version = 1;
    private int subVersion = 0;
    private int revision = 100;

    public static void main(String[] args) {
        VersionObject vo1 = null;
        VersionObject vo2 = null;
        VersionObject vo3 = null;
        try {
            vo1 = new VersionObject("2.17.947");
            vo2 = new VersionObject("2.17.946");
            vo3 = new VersionObject("-3.-2.-1");
            System.out.append("1->2: " + vo1.isGreaterThan(vo2));
            System.out.println();
        }
        catch (JFBaseException ex) {
            System.err.println(ex);
        }
    }

    public VersionObject() {
    }

    public VersionObject(int version, int subVersion, int revision) throws JFVersionNegativException {
        if (version < 0 || subVersion < 0 || revision < 0) {
            throw new JFVersionNegativException("version, subversion or revision is negative");
        }
        this.version = version;
        this.subVersion = subVersion;
        this.revision = revision;
    }

    public VersionObject(String fullVersion) throws JFNoVersionException, JFWrongVersionException, JFVersionNegativException {
        if (fullVersion == null) {
            throw new JFNoVersionException();
        }
        StringTokenizer st = new StringTokenizer(fullVersion, ".");
        int i = 0;
        while (st.hasMoreElements()) {
            if (i == 0) {
                this.version = Integer.valueOf(st.nextElement().toString());
                if (this.version < 0) {
                    throw new JFVersionNegativException("version is negative");
                }
            } else if (i == 1) {
                this.subVersion = Integer.valueOf(st.nextElement().toString());
                if (this.subVersion < 0) {
                    throw new JFVersionNegativException("subVersion is negative");
                }
            } else {
                this.revision = Integer.valueOf(st.nextElement().toString());
                if (this.revision < 0) {
                    throw new JFVersionNegativException("revision is negative");
                }
            }
            ++i;
        }
        if (i != 3) {
            throw new JFWrongVersionException("version " + fullVersion + " has " + i + " subitems!");
        }
    }

    public void setVersion(int version) throws JFVersionNegativException {
        if (version < 0) {
            throw new JFVersionNegativException("version is negative");
        }
        this.version = version;
    }

    public void setSubVersion(int subVersion) throws JFVersionNegativException {
        if (subVersion < 0) {
            throw new JFVersionNegativException("subversion is negative");
        }
        this.subVersion = subVersion;
    }

    public void setRevision(int revision) throws JFVersionNegativException {
        if (revision < 0) {
            throw new JFVersionNegativException("revision is negative");
        }
        this.revision = revision;
    }

    public boolean isGreaterThan(VersionObject compareVersionObject) throws JFNoVersionException {
        if (compareVersionObject == null) {
            throw new JFNoVersionException("compareVersionObject is null");
        }
        boolean isGreaterThan = false;
        if (this.version > compareVersionObject.getVersion()) {
            isGreaterThan = true;
        } else if (this.version == compareVersionObject.getVersion()) {
            if (this.subVersion > compareVersionObject.getSubVersion()) {
                isGreaterThan = true;
            } else if (this.subVersion == compareVersionObject.getSubVersion() && this.revision > compareVersionObject.getRevision()) {
                isGreaterThan = true;
            }
        }
        return isGreaterThan;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSubVersion() {
        return this.subVersion;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getFullVersion() {
        return this.version + "." + this.subVersion + "." + this.revision;
    }
}

