/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.threads;

import at.glawar.javaframework.gui.MainGUI;
import at.glawar.ssttool.gui.iframes.ClientFrame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class ClientThread
extends Thread {
    private final String ME = "ClientThread";
    private final String CLIENT = "Client.";
    private String host = null;
    private int port = 2001;
    private String serverTerminator = "";
    private String clientTerminator = "";
    private boolean goOn = true;
    private final Object lock = new Object();
    private Socket server;
    private boolean isRunning = false;
    private DataInputStream inputFromServer = null;
    private DataOutputStream output4Server = null;
    private boolean withResponse = false;
    private ArrayList responses = new ArrayList();
    private String lastMessageSent = null;
    private String responseText = "RE_";
    private MainGUI mainGUI = null;
    private ClientFrame clientFrame = null;

    public ClientThread(String host, int port, boolean withResponse) {
        this.host = host;
        this.port = port;
        this.withResponse = withResponse;
    }

    public void setClientFrame(ClientFrame clientFrame) {
        this.clientFrame = clientFrame;
    }

    private void doOutput(String outputText) {
        if (this.mainGUI == null) {
            System.out.println("ClientThread: " + outputText);
        } else {
            this.mainGUI.addOutputText(outputText);
            this.mainGUI.getMainBase().debug(outputText, "ClientThread");
            if (this.clientFrame != null) {
                this.clientFrame.addClientOutput(outputText);
            }
        }
    }

    private void doLog(Exception ex) {
        if (this.mainGUI == null) {
            ex.printStackTrace(System.err);
        } else {
            this.mainGUI.getMainBase().getLogFile().log2File(ex);
        }
    }

    public void setMainGUI(MainGUI mainGUI) {
        this.mainGUI = mainGUI;
    }

    public void setResponseText(String responseText) {
        this.responseText = responseText;
    }

    public void setServerTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\n";
        } else if ("crlf".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\r\n";
        } else if ("lfcr".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\n\r";
        }
    }

    public void setClientTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\n";
        } else if ("crlf".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\r\n";
        } else if ("lfcr".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\n\r";
        }
    }

    private Socket getServer() throws IOException {
        if (this.server == null) {
            this.doOutput("Client.I am testing");
            this.server = new Socket(this.host, this.port);
            this.doOutput("Client.Socket to server created (if)");
        } else if (!this.server.isConnected()) {
            this.doOutput("Client.Socket to server not connected");
            this.server = new Socket(this.host, this.port);
            this.doOutput("Client.Socket to server created (else)");
        }
        return this.server;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private DataInputStream getInputStreamFromServer() throws IOException {
        if (this.inputFromServer == null) {
            this.inputFromServer = new DataInputStream(this.getServer().getInputStream());
        }
        return this.inputFromServer;
    }

    private String getTelegram(String msg) {
        int i;
        if (msg != null && (i = msg.indexOf(this.serverTerminator)) > 0) {
            return msg.substring(0, i).trim();
        }
        return "";
    }

    private DataOutputStream getOutputStream4Server() {
        if (this.output4Server == null) {
            try {
                this.output4Server = new DataOutputStream(this.getServer().getOutputStream());
                this.output4Server.flush();
            }
            catch (IOException ex) {
                this.doLog(ex);
            }
        }
        return this.output4Server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.doOutput("Client.Starting client ...");
        this.goOn = true;
        try {
            int amountOfReadCharacters = 0;
            while (this.isGoOn()) {
                if (amountOfReadCharacters != -1) {
                    this.isRunning = true;
                    StringBuffer buffer = new StringBuffer();
                    amountOfReadCharacters = this.getInputStreamFromServer().read();
                    while (this.serverTerminator != null && amountOfReadCharacters >= 0 && buffer.append((char)amountOfReadCharacters).toString().indexOf(this.serverTerminator) < 0) {
                        amountOfReadCharacters = this.getInputStreamFromServer().read();
                    }
                    String telegram = buffer.toString();
                    if ((telegram = this.getTelegram(telegram)).length() <= 0) continue;
                    this.doOutput("Client.Received from server <" + telegram + ">");
                    this.responses.add(telegram);
                    continue;
                }
                this.doOutput("Client.Server is down");
                this.stopClient();
            }
        }
        catch (Exception ex) {
            this.doLog(ex);
        }
        finally {
            this.tryClosing();
        }
        this.isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.goOn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopClient() {
        Object object = this.lock;
        synchronized (object) {
            this.doOutput("Client.We are stopping now ...");
            this.goOn = false;
            this.tryClosing();
        }
    }

    private void tryClosing() {
        try {
            if (this.inputFromServer != null) {
                this.inputFromServer.close();
                this.inputFromServer = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean gotResponse4Message(String message) {
        boolean retVal = false;
        String tempMessage = this.responseText + message;
        retVal = this.responses.contains(tempMessage);
        this.responses.remove(tempMessage);
        return retVal;
    }

    public void sendMessage2Server(String message) throws IOException {
        if (this.withResponse && this.lastMessageSent != null) {
            while (!this.gotResponse4Message(this.lastMessageSent)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.doOutput("Client.Sending to server    <" + message + ">");
        this.getOutputStream4Server().writeBytes(message + this.clientTerminator);
        this.getOutputStream4Server().flush();
        this.lastMessageSent = message;
    }
}

