/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.gui.iframes;

import at.glawar.gladataadapter.GLAMySQLDataAdapter;
import at.glawar.gladataadapter.GLAOracleDataAdapter;
import at.glawar.interfaces.IGDataAdapter;
import at.glawar.javaframework.gui.base.BaseInternalFrame;
import at.glawar.javaframework.gui.listmodel.SortedListModel;
import at.glawar.ssttool.SSTToolMainBase;
import at.glawar.ssttool.gui.SSTToolGUI;
import at.glawar.ssttool.threads.ClientThread;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.DefaultCaret;

public class ClientFrame
extends BaseInternalFrame {
    private SSTToolGUI gui = null;
    private String connectText = this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_CONNECT");
    private String disconnectText = this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_DISCONNECT");
    private String server = null;
    private int port = 0;
    private ClientThread clientThread = null;
    private Connection conn = null;
    private SSTToolMainBase mainBaseSST = null;
    private SortedListModel listModel = new SortedListModel();
    private IGDataAdapter dataAdapter = null;
    private String connect2Database = this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_CONNECT_TO_DATABASE");
    private String disconnectFromDatabaser = this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_DISCONNECT_FROM_DATABASE");
    private JButton buttonConnect2Database;
    private JButton buttonConnectDisconnect;
    private JButton buttonCreateAndSend;
    private JButton buttonHelp;
    private JButton buttonSend;
    private JComboBox clientTerminator;
    private JTextField delimiterField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JList listTelegramTypes;
    private JTextField portField;
    private JTextField responseText;
    private JScrollPane scrollTextAreaOutput;
    private JCheckBox sendAfterReply;
    private JTextField serverField;
    private JComboBox serverTerminator;
    private JTable tableImport;
    private JTextField telegramField;
    private JTextArea textAreaOutput;

    public ClientFrame(Frame parent) {
        super(parent);
        this.initComponents();
        this.myInitComponents();
        this.multilingualism();
    }

    private void multilingualism() {
        this.setTitle(this.mainGUI.getMainBase().getLanguageEntryPersonal("MENU_CLIENT"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(this.mainGUI.getMainBase().getLanguageEntryPersonal("MENU_CLIENT")));
        this.jLabel1.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_SERVER"));
        this.jLabel2.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_PORT"));
        this.jLabel3.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_SERVER_TERMINATOR"));
        this.jLabel4.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_CLIENT_TERMINATOR"));
        this.sendAfterReply.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_SEND_ONLY_AFTER_REPLY"));
        this.buttonConnectDisconnect.setText(this.connectText);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_DATA")));
        this.jLabel5.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_TELEGRAM"));
        this.telegramField.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_INSERT_TELEGRAM_TEXT"));
        this.buttonSend.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_SEND"));
        this.buttonCreateAndSend.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_CREATE_AND_SEND"));
        this.jLabel6.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_DELIMITER"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_DATA_FROM_DATABASE")));
        this.buttonHelp.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_HELP"));
    }

    private void myInitComponents() {
        this.setTitle("Client");
        DefaultCaret caret = (DefaultCaret)this.textAreaOutput.getCaret();
        caret.setUpdatePolicy(2);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.gui = (SSTToolGUI)((Object)this.getFrame());
        this.mainBaseSST = (SSTToolMainBase)this.mainGUI.getMainBase();
        ImageIcon img = this.mainGUI.getMainBase().createImageIcon("/at/glawar/ssttool/icons/SSTTool.gif");
        this.setFrameIcon(img);
        this.serverTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "crlf", "lf", "lfcr"}));
        this.clientTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "crlf", "lf", "lfcr"}));
        if (this.gui.getSelectedConnection() != null) {
            this.serverField.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.SocketServer"));
            this.serverTerminator.setSelectedItem((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.Client.ServerTerminator"));
            this.clientTerminator.setSelectedItem((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.Client.ClientTerminator"));
            this.portField.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ClientPort"));
            String tmp = (String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.SendAfterReply");
            try {
                if ("1".compareTo(tmp) == 0) {
                    this.sendAfterReply.setSelected(true);
                    this.responseText.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ClientReplyText"));
                } else {
                    this.sendAfterReply.setSelected(false);
                }
            }
            catch (Exception ex) {
                this.sendAfterReply.setSelected(false);
            }
            this.delimiterField.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.TelegramDelimiter"));
        }
        this.buttonConnect2Database.setText(this.connect2Database);
        this.resetTable();
        this.gui.getHelpBroker().enableHelpOnButton((Component)this.buttonHelp, "CLIENT", this.gui.getHelpSet());
        this.textAreaOutput.setFont(new Font(this.mainBaseSST.getSSTToolFont(), 0, this.mainBaseSST.getSSTToolFontSize()));
    }

    private void resetTable() {
        this.tableImport.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
    }

    public IGDataAdapter getDataAdapter() throws Exception {
        if (this.dataAdapter == null) {
            String dbType = this.gui.getSelectedConnection().getDBType();
            if ("Oracle".compareTo(dbType) == 0) {
                this.dataAdapter = new GLAOracleDataAdapter(this.gui.getSelectedConnection().getDBProperties());
            } else if ("MySQL".compareTo(dbType) == 0) {
                this.dataAdapter = new GLAMySQLDataAdapter(this.gui.getSelectedConnection().getDBProperties());
            }
        }
        return this.dataAdapter;
    }

    protected void formInternalFrameClosing(InternalFrameEvent evt) {
        this.stopThread();
        this.disconnectFromDatabase();
        this.closeMe();
    }

    private void stopThread() {
        if (this.clientThread != null) {
            this.clientThread.stopClient();
        }
        this.buttonConnectDisconnect.setText(this.connectText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFulLTelegramType() {
        String PRETEXT = "ClientFrame.loadFulLTelegramType";
        int index = this.listTelegramTypes.getSelectedIndex();
        this.mainBaseSST.debug("Startet", "ClientFrame.loadFulLTelegramType");
        if (this.conn != null) {
            String select = (String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.SelectTelegram");
            ArrayList<String> alColumns = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(select, ",");
            int r = 0;
            while (st.hasMoreElements()) {
                String token = st.nextElement().toString();
                if ((token = token.trim().toUpperCase()).indexOf("SELECT") != -1) {
                    token = token.substring(7);
                } else if (token.indexOf("FROM") != -1) {
                    int j = token.indexOf("FROM");
                    token = token.substring(0, j - 1);
                }
                alColumns.add(token);
                ++r;
            }
            alColumns.add("DATA");
            int amountOfColumns = r + 1;
            Object[] columnNames = new String[amountOfColumns];
            for (int j = 0; j < amountOfColumns; ++j) {
                columnNames[j] = (String)alColumns.get(j);
            }
            int paramPos = select.indexOf("TELEGRAMTYPE");
            int len = "TELEGRAMTYPE".length();
            String pre = select.substring(0, paramPos);
            String post = select.substring(paramPos + len);
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this.conn.createStatement();
                rs = stmt.executeQuery(pre + this.listTelegramTypes.getModel().getElementAt(index) + post);
                Object[][] data = null;
                ArrayList<Object[]> list = new ArrayList<Object[]>();
                while (rs.next()) {
                    Object[] subData = new Object[]{rs.getInt(1), rs.getString(2), rs.getInt(3), rs.getInt(4), rs.getInt(5), null};
                    list.add(subData);
                }
                data = new Object[list.size()][6];
                for (int i = 0; i < list.size(); ++i) {
                    data[i] = (Object[])list.get(i);
                }
                this.tableImport.setModel(new DefaultTableModel(data, columnNames){
                    boolean[] canEdit;
                    {
                        this.canEdit = new boolean[]{false, false, false, false, false, true};
                    }

                    @Override
                    public boolean isCellEditable(int rowIndex, int columnIndex) {
                        return this.canEdit[columnIndex];
                    }
                });
                this.tableImport.getColumnModel().getColumn(0).setPreferredWidth(30);
                this.tableImport.getColumnModel().getColumn(0).setMaxWidth(30);
                this.tableImport.getColumnModel().getColumn(1).setPreferredWidth(130);
                this.tableImport.getColumnModel().getColumn(1).setMaxWidth(130);
                this.tableImport.getColumnModel().getColumn(2).setPreferredWidth(60);
                this.tableImport.getColumnModel().getColumn(2).setMaxWidth(60);
                this.tableImport.getColumnModel().getColumn(3).setPreferredWidth(80);
                this.tableImport.getColumnModel().getColumn(3).setMaxWidth(80);
                this.tableImport.getColumnModel().getColumn(4).setPreferredWidth(60);
                this.tableImport.getColumnModel().getColumn(4).setMaxWidth(60);
            }
            catch (SQLException ex) {
                this.mainBaseSST.getLogFile().log2File((Throwable)ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (SQLException ex_nothing) {}
            }
        } else {
            this.mainBaseSST.debug("Conn is null", "ClientFrame.loadFulLTelegramType");
        }
    }

    private void disconnectFromDatabase() {
        if (this.conn != null) {
            try {
                this.conn.close();
                this.conn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.listTelegramTypes.setModel(new SortedListModel());
        this.resetTable();
        this.buttonConnect2Database.setText(this.connect2Database);
    }

    private void doSendMessage() {
        if (this.clientThread != null && this.clientThread.isRunning()) {
            try {
                this.clientThread.sendMessage2Server(this.telegramField.getText());
            }
            catch (IOException ex) {
                this.mainGUI.addOutputText((Object)ex.toString());
            }
        }
    }

    public void addClientOutput(Object obj) {
        String tmp = "\n\r";
        if (obj != null) {
            tmp = obj.toString() + "\n\r";
        }
        this.textAreaOutput.append(tmp);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.serverField = new JTextField();
        this.portField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.serverTerminator = new JComboBox();
        this.clientTerminator = new JComboBox();
        this.buttonConnectDisconnect = new JButton();
        this.sendAfterReply = new JCheckBox();
        this.responseText = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel5 = new JLabel();
        this.telegramField = new JTextField();
        this.buttonSend = new JButton();
        this.jPanel3 = new JPanel();
        this.buttonConnect2Database = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.listTelegramTypes = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.tableImport = new JTable();
        this.buttonCreateAndSend = new JButton();
        this.jLabel6 = new JLabel();
        this.delimiterField = new JTextField();
        this.scrollTextAreaOutput = new JScrollPane();
        this.textAreaOutput = new JTextArea();
        this.buttonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Client"));
        this.jLabel1.setText("Server:");
        this.jLabel2.setText("Port:");
        this.jLabel3.setText("ServerTerminator:");
        this.jLabel4.setText("ClientTerminator:");
        this.serverTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "lf"}));
        this.clientTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "lf"}));
        this.buttonConnectDisconnect.setText("Connect");
        this.buttonConnectDisconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientFrame.this.buttonConnectDisconnectActionPerformed(evt);
            }
        });
        this.sendAfterReply.setText("send only after reply:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1, -1, 71, Short.MAX_VALUE).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverField, -2, 148, -2).addComponent(this.portField, -2, 64, -2))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.responseText, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.buttonConnectDisconnect, -2, 138, -2)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.sendAfterReply, -2, 226, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverTerminator, -2, 82, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.clientTerminator, -2, 80, -2))))))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.serverField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.portField, -2, -1, -2)).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.serverTerminator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.clientTerminator, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sendAfterReply).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.responseText, -2, -1, -2).addComponent(this.buttonConnectDisconnect)).addGap(0, 9, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Data"));
        this.jLabel5.setText("Telegram:");
        this.telegramField.setText("Insert telegram text here ...");
        this.buttonSend.setText("Send");
        this.buttonSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientFrame.this.buttonSendActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5, -2, 98, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.telegramField, -2, 572, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSend, -2, 95, -2).addGap(361, 361, 361)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.telegramField, -2, -1, -2).addComponent(this.buttonSend)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Data from database"));
        this.buttonConnect2Database.setText("Connect to database");
        this.buttonConnect2Database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientFrame.this.buttonConnect2DatabaseActionPerformed(evt);
            }
        });
        this.listTelegramTypes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ClientFrame.this.listTelegramTypesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.listTelegramTypes);
        this.tableImport.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.tableImport);
        this.buttonCreateAndSend.setText("Create and send");
        this.buttonCreateAndSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClientFrame.this.buttonCreateAndSendActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Delimiter:");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonCreateAndSend, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addComponent(this.buttonConnect2Database, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delimiterField, -2, 81, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 503, Short.MAX_VALUE).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.buttonCreateAndSend).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonConnect2Database).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 239, -2).addGap(18, 18, 18).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.delimiterField, -2, -1, -2))).addComponent(this.jScrollPane2, -2, 391, -2)).addContainerGap()));
        this.textAreaOutput.setColumns(20);
        this.textAreaOutput.setFont(new Font("Courier", 0, 14));
        this.textAreaOutput.setRows(5);
        this.scrollTextAreaOutput.setViewportView(this.textAreaOutput);
        this.buttonHelp.setText("jButton1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollTextAreaOutput).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.buttonHelp, -2, 111, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel2, -2, 810, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.buttonHelp))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.scrollTextAreaOutput, -2, 82, -2).addGap(7, 7, 7)));
        this.pack();
    }

    private void buttonConnectDisconnectActionPerformed(ActionEvent evt) {
        boolean parametersValid = true;
        if (this.buttonConnectDisconnect.getText().compareTo(this.connectText) == 0) {
            if (this.serverField.getText().length() == 0) {
                JOptionPane.showMessageDialog((Component)((Object)this), "You have not specified a valid server", this.getMainBase().getApplicationName() + " - Error reading server", 0);
            } else {
                this.server = this.serverField.getText();
                try {
                    this.port = Integer.valueOf(this.portField.getText());
                }
                catch (Exception ex) {
                    parametersValid = false;
                    JOptionPane.showMessageDialog((Component)((Object)this), "You have not specified a valid port", this.getMainBase().getApplicationName() + " - Error reading port", 0);
                }
                if (parametersValid && this.sendAfterReply.isSelected() && this.responseText.getText().length() == 0) {
                    parametersValid = false;
                    JOptionPane.showMessageDialog((Component)((Object)this), "You must specify a response text", this.getMainBase().getApplicationName() + " - Error reading watchdog response text", 0);
                }
                if (parametersValid) {
                    this.clientThread = new ClientThread(this.server, this.port, this.sendAfterReply.isSelected());
                    this.clientThread.setClientTerminator((String)this.clientTerminator.getSelectedItem());
                    this.clientThread.setServerTerminator((String)this.serverTerminator.getSelectedItem());
                    this.clientThread.setResponseText(this.responseText.getText());
                    this.clientThread.setMainGUI(this.mainGUI);
                    this.clientThread.setClientFrame(this);
                    this.clientThread.start();
                    this.buttonConnectDisconnect.setText(this.disconnectText);
                }
            }
        } else {
            this.stopThread();
        }
    }

    private void buttonSendActionPerformed(ActionEvent evt) {
        this.doSendMessage();
    }

    private void buttonCreateAndSendActionPerformed(ActionEvent evt) {
        String telegramText = "";
        String tableData = "";
        if (this.delimiterField.getText().length() == 0) {
            String tempData = "";
            int length = 0;
            int isNumber = 0;
            int o = 0;
            int tempLength = 0;
            for (int i = 0; i < this.tableImport.getModel().getRowCount(); ++i) {
                tempData = "";
                isNumber = (Integer)this.tableImport.getModel().getValueAt(i, 3);
                length = (Integer)this.tableImport.getModel().getValueAt(i, 2);
                tableData = (String)this.tableImport.getModel().getValueAt(i, 5);
                if (tableData != null && tableData.length() > 0) {
                    if (tableData.length() > length) {
                        tempData = tableData.substring(0, length);
                    } else if (isNumber == 1) {
                        for (o = tempLength = tableData.length(); o < length; ++o) {
                            tempData = tempData + "0";
                        }
                        tempData = tempData + tableData;
                    } else {
                        tempData = tableData;
                        for (o = tempLength = tableData.length(); o < length; ++o) {
                            tempData = tempData + " ";
                        }
                    }
                } else {
                    for (o = 0; o < length; ++o) {
                        tempData = tempData + " ";
                    }
                }
                telegramText = telegramText + tempData;
            }
            this.telegramField.setText(telegramText);
        } else {
            for (int i = 0; i < this.tableImport.getModel().getRowCount(); ++i) {
                tableData = (String)this.tableImport.getModel().getValueAt(i, 5);
                if (tableData == null) {
                    tableData = "";
                }
                telegramText = telegramText + tableData + this.delimiterField.getText();
            }
            this.telegramField.setText(telegramText);
        }
        this.doSendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buttonConnect2DatabaseActionPerformed(ActionEvent evt) {
        if (this.buttonConnect2Database.getText().compareTo(this.connect2Database) == 0) {
            Statement stmt = null;
            ResultSet rs = null;
            try {
                this.conn = this.getDataAdapter().getConnection();
                stmt = this.conn.createStatement();
                boolean i = false;
                rs = stmt.executeQuery((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.SelectTypes"));
                while (rs.next()) {
                    this.listModel.add((Object)rs.getString(1));
                }
                this.listTelegramTypes.setModel(this.listModel);
                this.listTelegramTypes.setSelectionMode(0);
                this.listTelegramTypes.setSelectedIndex(0);
                this.buttonConnect2Database.setText(this.disconnectFromDatabaser);
            }
            catch (SQLException ex) {
                this.mainBaseSST.getLogFile().log2File((Throwable)ex);
            }
            catch (Exception ex) {
                this.mainBaseSST.getLogFile().log2File((Throwable)ex);
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    if (stmt != null) {
                        stmt.close();
                        stmt = null;
                    }
                }
                catch (SQLException ex_nothingF) {}
            }
        } else {
            this.disconnectFromDatabase();
        }
    }

    private void listTelegramTypesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.loadFulLTelegramType();
        }
    }
}

