/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.gui.iframes;

import at.glawar.javaframework.gui.base.BaseInternalFrame;
import at.glawar.ssttool.SSTToolMainBase;
import at.glawar.ssttool.gui.SSTToolGUI;
import at.glawar.ssttool.threads.ServerThread;
import at.glawar.ssttool.threads.WatchdogThread;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.InternalFrameEvent;
import javax.swing.text.DefaultCaret;

public class ServerFrame
extends BaseInternalFrame {
    private SSTToolGUI gui = null;
    private SSTToolMainBase mainBaseSST = null;
    private int serverPort = 0;
    private int watchdogTime = 0;
    private String watchdogSend = null;
    private String automaticReplyText = null;
    private final String startServerText = this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_START_SERVER");
    private final String stopServerText = this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_STOP_SERVER");
    private ServerThread serverThread = null;
    private WatchdogThread watchdogThread = null;
    private int replyReplyTime = 0;
    private JButton buttonHelp;
    private JButton buttonStartStop;
    private JComboBox cbClientTerminator;
    private JComboBox cbServerTerminator;
    private JLabel labelClientTerminator;
    private JLabel labelDelay;
    private JLabel labelEvery;
    private JLabel labelPort;
    private JLabel labelSecond;
    private JLabel labelServerTerminator;
    private JPanel panelWatchdog;
    private JTextField replyDelay;
    private JTextField replyText;
    private JScrollPane scrollTextAreaOutput;
    private JCheckBox sendWatchdog;
    private JTextField serverPortField;
    private JTextArea textAreaOutput;
    private JCheckBox useAutomaticReply;
    private JTextField watchdogSeconds;
    private JTextField watchdogText;

    public ServerFrame(Frame parent) {
        super(parent);
        this.initComponents();
        this.myInitComponents();
        this.multilingualism();
    }

    private void multilingualism() {
        this.setTitle(this.mainGUI.getMainBase().getLanguageEntryPersonal("MENU_SERVER"));
        this.labelPort.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_PORT"));
        this.useAutomaticReply.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_AUTOMATIC_REPLY"));
        this.labelServerTerminator.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_SERVER_TERMINATOR"));
        this.labelClientTerminator.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_CLIENT_TERMINATOR"));
        this.sendWatchdog.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_SEND_WATCHDOG"));
        this.labelEvery.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_EVERY"));
        this.labelSecond.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_SECONDS"));
        this.buttonStartStop.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_START_SERVER"));
        this.buttonHelp.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("BUTTON_HELP"));
        this.labelDelay.setText(this.mainGUI.getMainBase().getLanguageEntryPersonal("LABEL_DELAY"));
    }

    private void myInitComponents() {
        String PRETEXT = "ServerFrame.myInitComponents";
        DefaultCaret caret = (DefaultCaret)this.textAreaOutput.getCaret();
        caret.setUpdatePolicy(2);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.gui = (SSTToolGUI)((Object)this.getFrame());
        this.mainBaseSST = (SSTToolMainBase)this.gui.getMainBase();
        ImageIcon img = this.mainGUI.getMainBase().createImageIcon("/at/glawar/ssttool/icons/SSTTool.gif");
        this.setFrameIcon(img);
        this.buttonStartStop.setText(this.startServerText);
        this.cbServerTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "crlf", "lf", "lfcr"}));
        this.cbClientTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "crlf", "lf", "lfcr"}));
        if (this.gui.getSelectedConnection() != null) {
            this.gui.getMainBase().debug("Selected DBName <" + this.gui.getSelectedConnection().getDBName() + ">", "ServerFrame.myInitComponents");
            this.gui.getMainBase().debug("Selected DBType <" + this.gui.getSelectedConnection().getDBType() + ">", "ServerFrame.myInitComponents");
            this.getMainBase().debug("DBName <" + this.gui.getSelectedConnection().getDBName() + "> is of dbType <" + this.gui.getSelectedConnection().getDBType() + ">", "ServerFrame.myInitComponents");
            this.getMainBase().debug("Parameter server is <" + this.gui.getSelectedConnection().getDBPropertyValue("server") + ">", "ServerFrame.myInitComponents");
            this.getMainBase().debug("Parameter CustomerWatchdog is <" + this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerWatchdog") + ">", "ServerFrame.myInitComponents");
            this.replyDelay.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerRelayReply"));
            this.serverPortField.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerPort"));
            String tmp = (String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerAutomaticReply");
            try {
                if ("1".compareTo(tmp) == 0) {
                    this.useAutomaticReply.setSelected(true);
                } else {
                    this.useAutomaticReply.setSelected(false);
                }
            }
            catch (Exception ex) {
                this.useAutomaticReply.setSelected(false);
            }
            this.replyText.setText((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerReplyText"));
            tmp = (String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerWatchdog");
            try {
                if (tmp.length() > 0) {
                    this.sendWatchdog.setSelected(true);
                    this.watchdogText.setText(tmp);
                } else {
                    this.sendWatchdog.setSelected(false);
                }
            }
            catch (Exception ex) {
                this.sendWatchdog.setSelected(false);
            }
            tmp = (String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.ServerWatchdogTimer");
            this.gui.getMainBase().debug("CustomerWatchdogTimer <" + tmp + ">", "ServerFrame.myInitComponents");
            this.watchdogSeconds.setText(tmp);
            this.cbClientTerminator.setSelectedItem((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.Server.ClientTerminator"));
            this.cbServerTerminator.setSelectedItem((String)this.gui.getSelectedConnection().getCommonPropertyValue("CP.Server.ServerTerminator"));
        }
        this.gui.getHelpBroker().enableHelpOnButton((Component)this.buttonHelp, "SERVER", this.gui.getHelpSet());
        this.textAreaOutput.setFont(new Font(this.mainBaseSST.getSSTToolFont(), 0, this.mainBaseSST.getSSTToolFontSize()));
    }

    protected void formInternalFrameClosing(InternalFrameEvent evt) {
        this.stopThreads();
        this.closeMe();
    }

    private void stopThreads() {
        if (this.watchdogThread != null) {
            this.watchdogThread.stopWatchdog();
        }
        if (this.serverThread != null) {
            this.serverThread.stopServer();
        }
        this.buttonStartStop.setText(this.startServerText);
    }

    public void addServerOutput(Object obj) {
        String tmp = "\n\r";
        if (obj != null) {
            tmp = obj.toString() + "\n\r";
        }
        this.textAreaOutput.append(tmp);
    }

    private void initComponents() {
        this.labelPort = new JLabel();
        this.serverPortField = new JTextField();
        this.buttonStartStop = new JButton();
        this.useAutomaticReply = new JCheckBox();
        this.replyText = new JTextField();
        this.panelWatchdog = new JPanel();
        this.sendWatchdog = new JCheckBox();
        this.watchdogText = new JTextField();
        this.labelEvery = new JLabel();
        this.watchdogSeconds = new JTextField();
        this.labelSecond = new JLabel();
        this.labelServerTerminator = new JLabel();
        this.cbServerTerminator = new JComboBox();
        this.labelClientTerminator = new JLabel();
        this.cbClientTerminator = new JComboBox();
        this.scrollTextAreaOutput = new JScrollPane();
        this.textAreaOutput = new JTextArea();
        this.buttonHelp = new JButton();
        this.replyDelay = new JTextField();
        this.labelDelay = new JLabel();
        this.setDefaultCloseOperation(2);
        this.labelPort.setText("Port:");
        this.buttonStartStop.setText("Start Server");
        this.buttonStartStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerFrame.this.buttonStartStopActionPerformed(evt);
            }
        });
        this.useAutomaticReply.setText("automatic Reply");
        this.useAutomaticReply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerFrame.this.useAutomaticReplyActionPerformed(evt);
            }
        });
        this.panelWatchdog.setBorder(BorderFactory.createTitledBorder("Watchdog"));
        this.sendWatchdog.setText("send Watchdog");
        this.sendWatchdog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerFrame.this.sendWatchdogActionPerformed(evt);
            }
        });
        this.labelEvery.setText("every");
        this.labelSecond.setText("seconds");
        GroupLayout panelWatchdogLayout = new GroupLayout(this.panelWatchdog);
        this.panelWatchdog.setLayout(panelWatchdogLayout);
        panelWatchdogLayout.setHorizontalGroup(panelWatchdogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWatchdogLayout.createSequentialGroup().addComponent(this.sendWatchdog, -2, 155, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.watchdogText, -2, 187, -2).addGap(4, 4, 4).addComponent(this.labelEvery).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.watchdogSeconds, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.labelSecond, -2, 75, -2).addContainerGap()));
        panelWatchdogLayout.setVerticalGroup(panelWatchdogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelWatchdogLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sendWatchdog).addComponent(this.watchdogText, -2, -1, -2).addComponent(this.labelEvery).addComponent(this.watchdogSeconds, -2, -1, -2).addComponent(this.labelSecond)));
        this.labelServerTerminator.setText("Server-Terminator:");
        this.cbServerTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "crclf", "lf", "lfcr"}));
        this.labelClientTerminator.setText("Client-Terminator:");
        this.cbClientTerminator.setModel(new DefaultComboBoxModel<String>(new String[]{"cr", "lf"}));
        this.textAreaOutput.setColumns(20);
        this.textAreaOutput.setFont(new Font("Courier New", 0, 14));
        this.textAreaOutput.setRows(5);
        this.scrollTextAreaOutput.setViewportView(this.textAreaOutput);
        this.buttonHelp.setText("jButton1");
        this.replyDelay.setText("0");
        this.labelDelay.setText("delay");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollTextAreaOutput).addGroup(layout.createSequentialGroup().addComponent(this.labelPort).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serverPortField, -2, 86, -2).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelClientTerminator, -1, -1, Short.MAX_VALUE).addComponent(this.labelServerTerminator, -1, 182, Short.MAX_VALUE).addComponent(this.useAutomaticReply, -1, 182, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbServerTerminator, -2, 78, -2).addComponent(this.cbClientTerminator, -2, 78, -2))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replyText, -2, 78, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.buttonStartStop, GroupLayout.Alignment.LEADING, -1, 147, Short.MAX_VALUE).addComponent(this.buttonHelp, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.labelDelay, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.replyDelay, -2, 63, -2)))).addComponent(this.panelWatchdog, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelPort).addComponent(this.serverPortField, -2, -1, -2).addComponent(this.useAutomaticReply).addComponent(this.replyText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelServerTerminator).addGap(15, 15, 15)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.buttonHelp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelClientTerminator).addComponent(this.buttonStartStop))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDelay).addComponent(this.replyDelay, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbServerTerminator, -2, -1, -2).addGap(10, 10, 10).addComponent(this.cbClientTerminator, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.panelWatchdog, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollTextAreaOutput, -1, 169, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void useAutomaticReplyActionPerformed(ActionEvent evt) {
        this.replyText.setEnabled(this.useAutomaticReply.isSelected());
    }

    private void sendWatchdogActionPerformed(ActionEvent evt) {
        this.watchdogText.setEnabled(this.sendWatchdog.isSelected());
        this.watchdogSeconds.setEnabled(this.sendWatchdog.isSelected());
    }

    private void buttonStartStopActionPerformed(ActionEvent evt) {
        boolean parametersValid = true;
        if (this.buttonStartStop.getText().compareTo(this.startServerText) == 0) {
            try {
                this.replyReplyTime = Integer.valueOf(this.replyDelay.getText());
            }
            catch (Exception ex) {
                parametersValid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_DELAY"), this.getMainBase().getApplicationName() + " - " + this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_DELAY_TITLE"), 0);
            }
            try {
                this.serverPort = Integer.valueOf(this.serverPortField.getText());
            }
            catch (Exception ex) {
                parametersValid = false;
                JOptionPane.showMessageDialog((Component)((Object)this), this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_PORT"), this.getMainBase().getApplicationName() + " - " + this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_PORT_TITLE"), 0);
            }
            if (parametersValid && this.sendWatchdog.isSelected()) {
                try {
                    this.watchdogTime = Integer.valueOf(this.watchdogSeconds.getText());
                }
                catch (Exception ex) {
                    parametersValid = false;
                    JOptionPane.showMessageDialog((Component)((Object)this), this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_WATCHDOG_TIME"), this.getMainBase().getApplicationName() + " - " + this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_WATCHDOG_TIME_TITLE"), 0);
                }
                if (parametersValid) {
                    if (this.watchdogText.getText().length() == 0) {
                        parametersValid = false;
                        JOptionPane.showMessageDialog((Component)((Object)this), this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_WATCHDOG_TEXT"), this.getMainBase().getApplicationName() + " - " + this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_WATCHDOG_TEXT_TITLE"), 0);
                    } else {
                        this.watchdogSend = this.watchdogText.getText();
                    }
                }
            }
            if (parametersValid && this.useAutomaticReply.isSelected()) {
                if (this.replyText.getText().length() == 0) {
                    parametersValid = false;
                    JOptionPane.showMessageDialog((Component)((Object)this), this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_REPLY_TEXT"), this.getMainBase().getApplicationName() + " - " + this.mainGUI.getMainBase().getLanguageEntryPersonal("ERROR_REPLY_TEXT_TITLE"), 0);
                } else {
                    this.automaticReplyText = this.replyText.getText();
                }
            }
            if (parametersValid) {
                this.serverThread = new ServerThread(true, this.replyReplyTime, this.serverPort);
                this.serverThread.setMainGUI(this.mainGUI);
                this.serverThread.setServerFrame(this);
                this.serverThread.setAutomaticResponse(this.automaticReplyText);
                this.serverThread.setClientTerminator((String)this.cbClientTerminator.getSelectedItem());
                this.serverThread.setServerTerminator((String)this.cbServerTerminator.getSelectedItem());
                this.serverThread.start();
                this.buttonStartStop.setText(this.stopServerText);
                if (this.watchdogSend != null) {
                    this.watchdogThread = new WatchdogThread();
                    this.watchdogThread.setMainGUI(this.mainGUI);
                    this.watchdogThread.setServerFrame(this);
                    this.watchdogThread.setWatchdogText(this.watchdogSend);
                    this.watchdogThread.setTerminator(this.serverThread.getServerTerminator());
                    this.watchdogThread.setWatchdogTime(this.watchdogTime);
                    this.watchdogThread.setServerThread(this.serverThread);
                    this.watchdogThread.start();
                }
            }
        } else {
            this.stopThreads();
        }
    }
}

