/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.threads;

import at.glawar.javaframework.gui.MainGUI;
import at.glawar.javaframework.utils.TimeUtils;
import at.glawar.ssttool.gui.iframes.ServerFrame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerThread
extends Thread {
    private final String ME = "ServerThread";
    private final String SERVER = "Server.";
    private ServerSocket server = null;
    private Socket connectionFromClient = null;
    private int port = 2000;
    private final Object lock = new Object();
    private boolean withResponse = false;
    private boolean withHandshake = false;
    private boolean isRunning = false;
    private boolean goOn = true;
    private String serverTerminator = "";
    private String clientTerminator = "";
    private String clientTelegram;
    private DataInputStream inputFromClient = null;
    private boolean initialized = false;
    private DataOutputStream output4Client = null;
    private int responseRelay = 0;
    private String preResponse = "";
    private int backlog = 10;
    private MainGUI mainGUI = null;
    private long gotTelegram = 0L;
    private ServerFrame serverFrame = null;
    private String connectedWithClient = null;

    public ServerThread(boolean withHandshake, int responseRelay, int port) {
        this.withHandshake = withHandshake;
        this.responseRelay = responseRelay;
        this.port = port;
    }

    private void doOutput(String outputText) {
        if (this.mainGUI == null) {
            System.out.println("ServerThread: " + outputText);
        } else {
            this.mainGUI.addOutputText((Object)outputText);
            this.mainGUI.getMainBase().debug(outputText, "ServerThread");
        }
        if (this.serverFrame != null) {
            this.serverFrame.addServerOutput(outputText);
        }
    }

    private void doLog(Exception ex) {
        if (this.mainGUI == null) {
            ex.printStackTrace(System.err);
        } else {
            this.mainGUI.getMainBase().getLogFile().log2File((Throwable)ex);
        }
    }

    public void setMainGUI(MainGUI mainGUI) {
        this.mainGUI = mainGUI;
    }

    public void setServerFrame(ServerFrame serverFrame) {
        this.serverFrame = serverFrame;
    }

    public void setAutomaticResponse(String reponseText) {
        if (reponseText == null) {
            this.withResponse = false;
        } else {
            this.withResponse = true;
            this.preResponse = reponseText;
        }
    }

    public ServerThread(int port, boolean withResponse, boolean withHandshake, int responseRelay) throws IOException {
        this.withResponse = withResponse;
        this.port = port;
        this.withHandshake = withHandshake;
        this.responseRelay = responseRelay;
    }

    private String getClientTelegram(String msg) {
        int i;
        if (msg != null && (i = msg.indexOf(this.clientTerminator)) > 0) {
            return msg.substring(0, i).trim();
        }
        return "";
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public String getServerTerminator() {
        return this.serverTerminator;
    }

    public void setServerTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\n";
        } else if ("crlf".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\r\n";
        } else if ("lfcr".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\n\r";
        }
    }

    public void setClientTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\n";
        } else if ("crlf".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\r\n";
        } else if ("lfcr".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\n\r";
        }
    }

    private ServerSocket getServer() throws IOException {
        if (this.server == null) {
            this.server = new ServerSocket(this.port, this.backlog);
            this.doOutput("Server.Server created (if)");
            if (this.connectedWithClient != null) {
                this.doOutput("Server.Client <" + this.connectedWithClient + "> has disconnected");
                this.initialized = false;
            }
        } else if (!this.server.isBound()) {
            this.doOutput("Server.Server not bound");
            this.server = new ServerSocket(this.port, this.backlog);
            this.doOutput("Server.Server created (else)");
        }
        return this.server;
    }

    private Socket getConnectionFromClient() throws IOException {
        if (this.connectionFromClient == null) {
            this.connectionFromClient = this.getServer().accept();
            this.connectedWithClient = this.connectionFromClient.getInetAddress().getHostName();
            this.doOutput("Server.Client <" + this.connectedWithClient + "> has connected");
        } else if (!this.connectionFromClient.isConnected()) {
            this.connectionFromClient = this.getServer().accept();
            this.doOutput("Server.Connection received from client <" + this.connectionFromClient.getInetAddress().getHostName() + ">");
            this.initialized = false;
        }
        return this.connectionFromClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.goOn;
        }
    }

    public DataOutputStream getOutputStream4Client() {
        if (this.output4Client == null) {
            try {
                this.output4Client = new DataOutputStream(this.getConnectionFromClient().getOutputStream());
                this.output4Client.flush();
            }
            catch (IOException ex) {
                this.doLog(ex);
            }
        }
        return this.output4Client;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void tryClosing() {
        try {
            if (this.inputFromClient != null) {
                this.inputFromClient.close();
                this.inputFromClient = null;
            }
            if (this.output4Client != null) {
                this.output4Client.close();
                this.output4Client = null;
            }
            if (this.connectionFromClient != null) {
                this.connectionFromClient.close();
                this.connectionFromClient = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopServer() {
        Object object = this.lock;
        synchronized (object) {
            this.doOutput("Server.We are stopping now at " + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss"));
            this.goOn = false;
            this.tryClosing();
        }
    }

    private DataInputStream getInputStreamFromClient() throws IOException {
        if (this.inputFromClient == null) {
            this.inputFromClient = new DataInputStream(this.getConnectionFromClient().getInputStream());
        }
        return this.inputFromClient;
    }

    private void doAnswer() throws IOException {
        this.doOutput("Server.automatic Answer   <" + this.getAnswer4Client(this.clientTelegram) + ">");
        this.getOutputStream4Client().writeBytes(this.getAnswer4Client(this.clientTelegram) + this.serverTerminator);
        this.getOutputStream4Client().flush();
    }

    private void noticeTime() {
        this.gotTelegram = TimeUtils.getActualTime();
        this.doOutput("Server.Got telegram at    <" + TimeUtils.getDateAndTime((long)this.gotTelegram, (String)"yyyy:MM:dd HH:mm:ss") + ">");
    }

    public long getNoticedTime() {
        return this.gotTelegram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.doOutput("Server.Starting server at " + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss"));
        this.gotTelegram = TimeUtils.getActualTime();
        this.goOn = true;
        while (this.isGoOn()) {
            try {
                if (!this.initialized && this.withHandshake) {
                    this.doOutput("Server.We will try to send a message to the client (HandShake) ...");
                    this.getOutputStream4Client().writeBytes(this.getWelcomeMessage4Client());
                    this.getOutputStream4Client().flush();
                    this.doOutput("Server." + this.getWelcomeMessage4Client());
                    this.initialized = true;
                }
                this.isRunning = true;
                int amountOfReadCharacters = 0;
                while (this.isGoOn() && amountOfReadCharacters != -1) {
                    StringBuffer buffer = new StringBuffer();
                    amountOfReadCharacters = this.getInputStreamFromClient().read();
                    while (this.clientTerminator != null && amountOfReadCharacters >= 0 && buffer.append((char)amountOfReadCharacters).toString().indexOf(this.clientTerminator) < 0) {
                        amountOfReadCharacters = this.getInputStreamFromClient().read();
                    }
                    this.clientTelegram = buffer.toString();
                    this.clientTelegram = this.getClientTelegram(this.clientTelegram);
                    if (this.clientTelegram.length() <= 0) continue;
                    this.doOutput("Server.Got client message <" + this.clientTelegram + ">");
                    this.noticeTime();
                    if (!this.withResponse) continue;
                    try {
                        Thread.sleep(this.responseRelay);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    this.doAnswer();
                }
                this.isRunning = false;
            }
            catch (Exception ex) {
                this.doLog(ex);
            }
            finally {
                this.tryClosing();
            }
        }
        this.doOutput("Server.Finished server at " + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss"));
    }

    private String getAnswer4Client(String message) {
        return this.preResponse + message;
    }

    private String getWelcomeMessage4Client() {
        if (this.connectionFromClient != null) {
            return "Hello client <" + this.connectionFromClient.getInetAddress().getHostName() + "> on port <" + this.connectionFromClient.getPort() + "> you are connected now to server <" + this.connectionFromClient.getLocalAddress().getHostName() + "> on port <" + this.connectionFromClient.getLocalPort() + ">" + this.serverTerminator;
        }
        return "no connectionFromClient";
    }
}

