/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.ssttool.threads;

import at.glawar.javaframework.gui.MainGUI;
import at.glawar.javaframework.utils.TimeUtils;
import at.glawar.ssttool.gui.iframes.ServerFrame;
import at.glawar.ssttool.threads.ServerThread;
import java.io.IOException;

public class WatchdogThread
extends Thread {
    private final String ME = "WatchdogThread";
    private final String WATCHDOG = "Watchdog.";
    private final long seconds = 1000L;
    private MainGUI mainGUI = null;
    private final Object lock = new Object();
    private boolean isRunning = false;
    private boolean goOn = true;
    private String watchDogText = null;
    private String terminator = null;
    private int time = 0;
    private long nextWatchdog = 0L;
    private ServerThread serverThread = null;
    private ServerFrame serverFrame = null;

    public void setWatchdogTime(int time) {
        this.time = time;
    }

    public void setTerminator(String terminator) {
        this.terminator = terminator;
    }

    public void setServerThread(ServerThread serverThread) {
        this.serverThread = serverThread;
    }

    public void setWatchdogText(String watchDogText) {
        this.watchDogText = watchDogText;
    }

    public void setMainGUI(MainGUI mainGUI) {
        this.mainGUI = mainGUI;
    }

    public void setServerFrame(ServerFrame serverFrame) {
        this.serverFrame = serverFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.goOn;
        }
    }

    private void doOutput(String outputText) {
        if (this.mainGUI == null) {
            System.out.println("WatchdogThread: " + outputText);
        } else {
            this.mainGUI.addOutputText((Object)outputText);
            this.mainGUI.getMainBase().debug(outputText, "WatchdogThread");
        }
        if (this.serverFrame != null) {
            this.serverFrame.addServerOutput(outputText);
        }
    }

    private void doLog(Exception ex) {
        if (this.mainGUI == null) {
            ex.printStackTrace(System.err);
        } else {
            this.mainGUI.getMainBase().getLogFile().log2File((Throwable)ex);
        }
    }

    private void doWatchdog() throws IOException {
        this.doOutput("Watchdog.Doing Watchdog at    <" + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss") + ">, next planned <" + TimeUtils.getDateAndTime((long)this.nextWatchdog, (String)"yyyy:MM:dd HH:mm:ss") + ">");
        this.serverThread.getOutputStream4Client().writeBytes(this.watchDogText + this.terminator);
        this.serverThread.getOutputStream4Client().flush();
    }

    @Override
    public void run() {
        this.doOutput("Watchdog.Starting server at <" + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss") + "> with time-seconds <" + this.time + ">");
        this.nextWatchdog = 0L;
        this.goOn = true;
        while (!this.serverThread.isRunning()) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        while (this.isGoOn()) {
            if (this.nextWatchdog == 0L) {
                this.nextWatchdog = TimeUtils.getActualTime() + (long)this.time * 1000L;
                try {
                    this.doWatchdog();
                }
                catch (IOException ex) {
                    this.doLog(ex);
                }
            } else {
                long actualTime = TimeUtils.getActualTime();
                if (actualTime >= this.nextWatchdog) {
                    long noticedTime = this.serverThread.getNoticedTime();
                    this.doOutput("Watchdog.Got noticedTime at   <" + TimeUtils.getDateAndTime((long)noticedTime, (String)"yyyy:MM:dd HH:mm:ss") + ">");
                    if (noticedTime + (long)this.time * 1000L <= actualTime) {
                        try {
                            this.nextWatchdog += (long)this.time * 1000L;
                            this.doWatchdog();
                        }
                        catch (IOException ex) {
                            this.doLog(ex);
                        }
                    } else {
                        this.nextWatchdog = noticedTime + (long)this.time * 1000L;
                        this.doOutput("Watchdog.Watchdog resettet to <" + TimeUtils.getDateAndTime((long)this.nextWatchdog, (String)"yyyy:MM:dd HH:mm:ss") + ">");
                    }
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        this.isRunning = false;
        this.doOutput("Watchdog.Finished server at " + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopWatchdog() {
        Object object = this.lock;
        synchronized (object) {
            this.doOutput("Watchdog.We are stopping now at " + TimeUtils.getActualTimeString((String)"yyyy:MM:dd HH:mm:ss"));
            this.goOn = false;
        }
    }
}

