/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.test;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TestServer
extends Thread {
    private final String ME = "SERVER: ";
    private ServerSocket server = null;
    private Socket connectionFromClient = null;
    private int port = 2000;
    private final Object lock = new Object();
    private boolean withResponse = false;
    private boolean withHandshake = false;
    private boolean isRunning = false;
    private boolean goOn = true;
    private String serverTerminator = "";
    private String clientTerminator = "";
    private String clientTelegram;
    private DataInputStream inputFromClient = null;
    private boolean initialized = false;
    private DataOutputStream output4Client = null;
    private int responseRelay = 0;
    private String preResponse = "";
    private String postResponse = "";
    private int backlog = 10;

    public static void main(String[] args) {
        TestServer testServer = null;
        try {
            testServer = new TestServer(2000, true, true, 0);
            testServer.setServerTerminator("cr");
            testServer.setClientTerminator("cr");
            testServer.setPreResponse("RE_");
            testServer.start();
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public TestServer(int port, boolean withResponse, boolean withHandshake, int responseRelay) throws IOException {
        this.withResponse = withResponse;
        this.port = port;
        this.withHandshake = withHandshake;
        this.responseRelay = responseRelay;
    }

    public String getActualTimeString() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(Calendar.getInstance().getTime());
        Date dValue = cal.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
        return formatter.format(dValue);
    }

    private String getClientTelegram(String msg) {
        int i;
        if (msg != null && (i = msg.indexOf(this.clientTerminator)) > 0) {
            return msg.substring(0, i).trim();
        }
        return "";
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setPreResponse(String preResponse) {
        this.preResponse = preResponse;
    }

    public void setPostResponse(String postResponse) {
        this.postResponse = postResponse;
    }

    public void setServerTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.serverTerminator = this.serverTerminator + "\n";
        }
    }

    public void setClientTerminator(String terminator) {
        if ("cr".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\r";
        } else if ("lf".equals(terminator)) {
            this.clientTerminator = this.clientTerminator + "\n";
        }
    }

    private ServerSocket getServer() throws IOException {
        if (this.server == null) {
            this.server = new ServerSocket(this.port, this.backlog);
            System.out.println("SERVER: Server created (if)");
        } else if (!this.server.isBound()) {
            System.out.println("SERVER: Server not bound");
            this.server = new ServerSocket(this.port, this.backlog);
            System.out.println("SERVER: Server created (else)");
        }
        return this.server;
    }

    private Socket getConnectionFromClient() throws IOException {
        if (this.connectionFromClient == null) {
            this.connectionFromClient = this.getServer().accept();
            System.out.println("SERVER: Connection received from client <" + this.connectionFromClient.getInetAddress().getHostName() + ">");
        } else if (!this.connectionFromClient.isConnected()) {
            this.connectionFromClient = this.getServer().accept();
            System.out.println("SERVER: Connection received from client <" + this.connectionFromClient.getInetAddress().getHostName() + ">");
            this.initialized = false;
        }
        return this.connectionFromClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGoOn() {
        Object object = this.lock;
        synchronized (object) {
            return this.goOn;
        }
    }

    private DataOutputStream getOutputStream4Client() {
        if (this.output4Client == null) {
            try {
                this.output4Client = new DataOutputStream(this.getConnectionFromClient().getOutputStream());
                this.output4Client.flush();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
        return this.output4Client;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    private void tryClosing() {
        try {
            if (this.inputFromClient != null) {
                this.inputFromClient.close();
                this.inputFromClient = null;
            }
            if (this.output4Client != null) {
                this.output4Client.close();
                this.output4Client = null;
            }
            if (this.connectionFromClient != null) {
                this.connectionFromClient.close();
                this.connectionFromClient = null;
            }
            if (this.server != null) {
                this.server.close();
                this.server = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopServer() {
        Object object = this.lock;
        synchronized (object) {
            System.out.println("SERVER: We are stopping now at " + this.getActualTimeString());
            this.goOn = false;
            this.tryClosing();
        }
    }

    private DataInputStream getInputStreamFromClient() throws IOException {
        if (this.inputFromClient == null) {
            this.inputFromClient = new DataInputStream(this.getConnectionFromClient().getInputStream());
        }
        return this.inputFromClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println("SERVER: Starting server at " + this.getActualTimeString());
        this.goOn = true;
        while (this.isGoOn()) {
            try {
                this.isRunning = true;
                if (!this.initialized && this.withHandshake) {
                    System.out.println("SERVER: We will try to send a message to the client (HandShake) ...");
                    this.getOutputStream4Client().writeBytes(this.getWelcomeMessage4Client());
                    this.getOutputStream4Client().flush();
                    System.out.append(this.getWelcomeMessage4Client());
                    this.initialized = true;
                }
                int amountOfReadCharacters = 0;
                while (this.isGoOn() && amountOfReadCharacters != -1) {
                    StringBuffer buffer = new StringBuffer();
                    amountOfReadCharacters = this.getInputStreamFromClient().read();
                    while (this.clientTerminator != null && amountOfReadCharacters >= 0 && buffer.append((char)amountOfReadCharacters).toString().indexOf(this.clientTerminator) < 0) {
                        amountOfReadCharacters = this.getInputStreamFromClient().read();
                    }
                    this.clientTelegram = buffer.toString();
                    this.clientTelegram = this.getClientTelegram(this.clientTelegram);
                    if (this.clientTelegram.length() <= 0) continue;
                    System.out.println("SERVER: Message from client <" + this.clientTelegram + ">");
                    if (!this.withResponse) continue;
                    try {
                        Thread.sleep(this.responseRelay);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    System.out.println("SERVER: automatic Answer to client <" + this.getAnswer4Client(this.clientTelegram) + ">");
                    this.getOutputStream4Client().writeBytes(this.getAnswer4Client(this.clientTelegram) + this.serverTerminator);
                    this.getOutputStream4Client().flush();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                this.tryClosing();
            }
        }
        this.isRunning = false;
        System.out.println("SERVER: Finished server at " + this.getActualTimeString());
    }

    private String getAnswer4Client(String message) {
        return this.preResponse + message + this.postResponse;
    }

    private String getWelcomeMessage4Client() {
        if (this.connectionFromClient != null) {
            return "Hello " + this.connectionFromClient.getInetAddress() + " on port " + this.connectionFromClient.getPort() + "; This is " + this.connectionFromClient.getLocalAddress() + " on port " + this.connectionFromClient.getLocalPort() + "\r\n";
        }
        return "no connectionFromClient";
    }
}

