/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.gui;

import at.glawar.javaframework.MainBase;
import at.glawar.javaframework.gui.jdialogs.DialogAboutBox;
import at.glawar.test.gui.iframe.MyFirstInternalFrame;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.DefaultCaret;

public class MainGUI
extends JFrame {
    private DialogAboutBox aboutBox;
    protected MainBase mainBase = null;
    private boolean detailedOutput = true;
    private UIManager.LookAndFeelInfo[] availableLookAndFeels = null;
    private JRadioButtonMenuItem[] menuItemRadioLookAndFeel;
    private String selectedLookAndFeelClassName = null;
    private JMenu menuDevelopment;
    private JMenu menuScreenResolution;
    private JRadioButtonMenuItem[] menuItemScreenResolution;
    private JSeparator menuItemWindowSeparator;
    private JRadioButtonMenuItem[] menuItemRadioWindowsOpened;
    private JMenuItem menuItemCascadeWindow;
    private JMenuItem menuItemDevelopmentAction;
    private String[] availableLanguages = null;
    private JRadioButtonMenuItem[] menuItemRadioAvailableLanguages;
    private String defaultLanguage;
    private JMenuBar menuBarMain;
    private JMenu menuConfiguration;
    private JMenu menuFile;
    private JMenu menuHelp;
    private JMenuItem menuHelpMe;
    private JMenuItem menuItemAbout;
    private JMenuItem menuItemClearOutputWindow;
    private JCheckBoxMenuItem menuItemDetailedOutput;
    private JMenuItem menuItemExit;
    private JMenu menuLanguages;
    private JMenu menuLookAndFeel;
    private JMenu menuOutput;
    private JMenu menuWindow;
    private JTextArea outputWindow;
    private JDesktopPane panelDesktop;
    private JScrollPane panelScroll;
    private JSplitPane panelSplit;

    public static void main(final String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(MainGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MainGUI(args).setVisible(true);
            }
        });
    }

    public MainGUI(String[] args) {
        this.initComponents();
        this.myInitComponents(args);
    }

    protected JMenu getMenuHelp() {
        return this.menuHelp;
    }

    protected JTextArea getOutputWindow() {
        return this.outputWindow;
    }

    public JMenuItem getMenuHelpMe() {
        return this.menuHelpMe;
    }

    public MainBase getMainBase() {
        if (this.mainBase == null) {
            this.mainBase = new MainBase();
        }
        return this.mainBase;
    }

    protected JMenu getMenuFile() {
        return this.menuFile;
    }

    protected JMenu getMenuDevelopment() {
        if (this.menuDevelopment == null) {
            this.menuDevelopment = new JMenu();
            this.menuDevelopment.setText(this.mainBase.getLanguageEntry("MENU_DEVELOPMENT"));
            char[] mnemonics = this.mainBase.getLanguageEntry("MENU_DEVELOPMENT_MNEMONIC").toCharArray();
            this.menuDevelopment.setMnemonic(mnemonics[0]);
        }
        return this.menuDevelopment;
    }

    protected JMenu getMenuScreenResolution() {
        if (this.menuScreenResolution == null) {
            this.menuScreenResolution = new JMenu();
            this.menuScreenResolution.setText(this.mainBase.getLanguageEntry("MENU_SCREEN_RESOLUTION"));
            char[] mnemonics = this.mainBase.getLanguageEntry("MENU_DEVELOPMENT_MNEMONIC").toCharArray();
            this.menuScreenResolution.setMnemonic(mnemonics[0]);
        }
        return this.menuScreenResolution;
    }

    public JMenu getMenuConfiguration() {
        return this.menuConfiguration;
    }

    private void setDividerLocation() {
        String PRETEXT = "MainGUI.setDividerLocation()";
        String dividerLocation = this.getMainBase().getConfigFile().getConfigFileValue("Window", "dividerHeight");
        int iDividerLocation = 0;
        try {
            iDividerLocation = Integer.parseInt(dividerLocation);
        }
        catch (Exception ex) {
            this.getMainBase().debug("No divider location saved in ini-File", "MainGUI.setDividerLocation()");
        }
        if (iDividerLocation == 0) {
            int tempHeight = 0;
            if (this.getExtendedState() == 6) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension screenSize = toolkit.getScreenSize();
                tempHeight = screenSize.height;
                this.getMainBase().debug("Application is maximized to height <" + tempHeight + ">", "MainGUI.setDividerLocation()");
            } else {
                tempHeight = this.getHeight();
                this.getMainBase().debug("Application's height <" + tempHeight + ">", "MainGUI.setDividerLocation()");
            }
            double factor = 0.75;
            double dDividerLocation = (double)tempHeight * factor;
            iDividerLocation = (int)dDividerLocation;
        }
        this.getMainBase().debug("setting divider location to <" + iDividerLocation + ">", "MainGUI.setDividerLocation()");
        this.getPanelSplit().setDividerLocation(iDividerLocation);
        this.getMainBase().getConfigFile().setConfigFileValue("Window", "dividerHeight", iDividerLocation);
    }

    private void myInitComponents(String[] args) {
        int i;
        String PREOUTTEXT = "MainGUI.myInitComponents";
        DefaultCaret caret = (DefaultCaret)this.outputWindow.getCaret();
        caret.setUpdatePolicy(2);
        this.getMainBase().setPanelDesktop(this.panelDesktop);
        if (!this.getMainBase().determineArgs(args)) {
            JOptionPane.showMessageDialog(this, "There are errors in your given command-line parameters!\n\rTherefore it makes no sense to go on.\n\r\n\rThe application will now exit.", this.getMainBase().getApplicationName() + " - Error reading command-line parameters", 0);
            System.exit(3);
        }
        if (this.getMainBase().getSVNRevisionOfJavaFramework() < this.getMainBase().getMinFrameworkRevision()) {
            JOptionPane.showMessageDialog(this, "SVN-Revision of your installed JavaFramework does not suite (" + this.getMainBase().getMinFrameworkRevision() + ")!\n\rTherefore it makes no sense to go on.\n\r\n\rThe application will now exit.", this.getMainBase().getApplicationName() + " - Error SVN-Revision", 0);
            System.exit(5);
        }
        this.getMainBase().init();
        this.setTitle("Java Framework GUI");
        this.getMainBase().debug("Reading Window-Information from Config-file", "MainGUI.myInitComponents");
        String extendedStateStr = this.getMainBase().getConfigFile().getConfigFileValue("Window", "extendedState");
        this.getMainBase().debug("extendedStateStr <" + extendedStateStr + ">", "MainGUI.myInitComponents");
        if (extendedStateStr != null) {
            int extendedState = Integer.parseInt(extendedStateStr);
            if (extendedState != 6) {
                this.getMainBase().debug("we must set everything separately", "MainGUI.myInitComponents");
                int x = Integer.parseInt(this.getMainBase().getConfigFile().getConfigFileValue("Window", "x"));
                int y = Integer.parseInt(this.getMainBase().getConfigFile().getConfigFileValue("Window", "y"));
                int width = Integer.parseInt(this.getMainBase().getConfigFile().getConfigFileValue("Window", "width"));
                int height = Integer.parseInt(this.getMainBase().getConfigFile().getConfigFileValue("Window", "height"));
                this.setBounds(x, y, width, height);
                this.setExtendedState(extendedState);
            } else {
                this.getMainBase().debug("we set the state", "MainGUI.myInitComponents");
                this.setExtendedState(6);
            }
        }
        this.setDividerLocation();
        this.defaultLanguage = this.getMainBase().getConfigFile().getConfigFileValue(this.getMainBase().getApplicationName(), "lang");
        this.getMainBase().debug("Setting default language <" + this.defaultLanguage + "> from config file", "MainGUI.myInitComponents");
        if (this.defaultLanguage == null) {
            this.defaultLanguage = "en";
            this.getMainBase().getConfigFile().setConfigFileValue(this.getMainBase().getApplicationName(), "lang", this.defaultLanguage);
            this.getMainBase().debug("Setting default language <" + this.defaultLanguage + "> to config file", "MainGUI.myInitComponents");
        }
        Locale.setDefault(new Locale(this.defaultLanguage));
        this.availableLanguages = new String[2];
        this.availableLanguages[0] = "en";
        this.availableLanguages[1] = "de";
        this.menuItemRadioAvailableLanguages = new JRadioButtonMenuItem[this.availableLanguages.length];
        if (this.menuItemRadioAvailableLanguages != null) {
            ButtonGroup group = new ButtonGroup();
            for (i = 0; i < this.menuItemRadioAvailableLanguages.length; ++i) {
                this.menuItemRadioAvailableLanguages[i] = new JRadioButtonMenuItem();
                this.menuItemRadioAvailableLanguages[i].setText(this.availableLanguages[i]);
                this.menuItemRadioAvailableLanguages[i].setSelected(this.availableLanguages[i].compareTo(this.defaultLanguage) == 0);
                group.add(this.menuItemRadioAvailableLanguages[i]);
                this.menuLanguages.add(this.menuItemRadioAvailableLanguages[i]);
                this.menuItemRadioAvailableLanguages[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        MainGUI.this.chooseLanguage(ae);
                    }
                });
            }
        }
        if (this.getMainBase().update(this)) {
            this.getMainBase().getLogFile().log2File(this.getMainBase().getApplicationName() + ".Update done", "MainGUI.myInitComponents");
            JOptionPane.showMessageDialog(this, this.getMainBase().getLanguageEntry("DIALOG_HINT_UPDATE_DONE"));
            this.getMainBase().closeApplication(0);
        } else {
            this.getMainBase().getLogFile().log2File(this.getMainBase().getApplicationName() + ".Update not done");
        }
        this.availableLookAndFeels = UIManager.getInstalledLookAndFeels();
        this.selectedLookAndFeelClassName = this.getMainBase().getConfigFile().getConfigFileValue(this.getMainBase().getApplicationName(), "lookandfeel");
        this.getMainBase().debug("Setting look and feel <" + this.selectedLookAndFeelClassName + "> from config file", "MainGUI.myInitComponents");
        if (this.selectedLookAndFeelClassName == null) {
            this.selectedLookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(this.selectedLookAndFeelClassName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            this.mainBase.getLogFile().log2File(ex, "MainGUI.myInitComponents");
        }
        this.menuItemRadioLookAndFeel = new JRadioButtonMenuItem[this.availableLookAndFeels.length];
        if (this.menuItemRadioLookAndFeel != null) {
            ButtonGroup group = new ButtonGroup();
            for (i = 0; i < this.menuItemRadioLookAndFeel.length; ++i) {
                this.menuItemRadioLookAndFeel[i] = new JRadioButtonMenuItem();
                this.menuItemRadioLookAndFeel[i].setText(this.availableLookAndFeels[i].getName());
                this.menuItemRadioLookAndFeel[i].setSelected(this.availableLookAndFeels[i].getClassName().compareTo(this.selectedLookAndFeelClassName) == 0);
                group.add(this.menuItemRadioLookAndFeel[i]);
                this.menuLookAndFeel.add(this.menuItemRadioLookAndFeel[i]);
                this.menuItemRadioLookAndFeel[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        MainGUI.this.chooseLookAndFeel(ae);
                    }
                });
            }
        }
        int d0 = 0;
        try {
            d0 = new Integer(this.getMainBase().getConfigFile().getConfigFileValue(this.getMainBase().getApplicationName(), "detailedOutput"));
        }
        catch (Exception ex_nothing) {
            // empty catch block
        }
        this.getMainBase().debug("Setting detailed output <" + d0 + "> from config file", "MainGUI.myInitComponents");
        this.detailedOutput = d0 == 1;
        this.menuItemDetailedOutput.setSelected(this.detailedOutput);
        if (this.getMainBase().isDebugModus()) {
            this.addOutputText(this.mainBase.getLanguageEntry("MSG_DEBUG_ON"));
            if (this.detailedOutput) {
                this.addOutputTextDetailed("\n\r" + this.mainBase.getLanguageEntry("MSG_D_OUTPUT_ON"));
            } else {
                this.addOutputText("\n\r" + this.mainBase.getLanguageEntry("MSG_D_OUTPUT_OFF"));
            }
        }
        if (this.mainBase.isDevelopmentVersion()) {
            this.getMainBase().debug("Development-version is activated", "MainGUI.myInitComponents");
            this.menuBarMain.removeAll();
            this.menuBarMain.add(this.menuFile);
            this.menuBarMain.add(this.menuConfiguration);
            this.getMenuDevelopment().add(this.getMenuScreenResolution());
            this.menuItemScreenResolution = new JRadioButtonMenuItem[5];
            if (this.menuItemScreenResolution != null) {
                ButtonGroup bgScreenResolution = new ButtonGroup();
                this.menuItemScreenResolution[0] = new JRadioButtonMenuItem();
                this.menuItemScreenResolution[0].setText("640x480");
                this.menuItemScreenResolution[1] = new JRadioButtonMenuItem();
                this.menuItemScreenResolution[1].setText("800x600");
                this.menuItemScreenResolution[2] = new JRadioButtonMenuItem();
                this.menuItemScreenResolution[2].setText("1024x768");
                this.menuItemScreenResolution[3] = new JRadioButtonMenuItem();
                this.menuItemScreenResolution[3].setText("1280x720");
                this.menuItemScreenResolution[4] = new JRadioButtonMenuItem();
                this.menuItemScreenResolution[4].setText("1600x900");
                for (int i2 = 0; i2 < this.menuItemScreenResolution.length; ++i2) {
                    bgScreenResolution.add(this.menuItemScreenResolution[i2]);
                    this.menuScreenResolution.add(this.menuItemScreenResolution[i2]);
                    this.menuItemScreenResolution[i2].addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            MainGUI.this.chooseScreenResolution(ae);
                        }
                    });
                }
            }
            this.menuBarMain.add(this.getMenuDevelopment());
            this.menuBarMain.add(this.menuWindow);
            this.menuBarMain.add(this.menuHelp);
            this.menuItemDevelopmentAction = new JMenuItem();
            this.menuItemDevelopmentAction.setText("Development-Action");
            this.menuItemDevelopmentAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MainGUI.this.developmentAction(ae);
                }
            });
            this.getMenuDevelopment().add(this.menuItemDevelopmentAction);
        }
        ImageIcon img = this.getMainBase().createImageIcon("/at/glawar/javaframework/icons/javaframework-24x24.gif");
        this.setIconImage(img.getImage());
        this.setMultilignualism();
        this.outputWindow.setFont(new Font(this.getMainBase().getOutputWindowFont(), 0, this.getMainBase().getOutputWindowFontSize()));
    }

    protected void developmentAction(ActionEvent ae) {
        String PREOUTTEXT = "MainGUI.developmentAction";
        this.mainBase.debug("Development-Action klicked", "MainGUI.developmentAction");
        JInternalFrame[] frames = this.panelDesktop.getAllFrames();
        MyFirstInternalFrame internal = (MyFirstInternalFrame)frames[0];
        this.addOutputText("Title is " + internal.getTitle());
        this.addOutputText("height is " + internal.getBounds().height);
        this.addOutputText("width is " + internal.getBounds().width);
        if (internal.isMaximum()) {
            this.addOutputText("internal frame is maximized");
        }
        try {
            internal.setMaximum(true);
        }
        catch (PropertyVetoException ex) {
            this.mainBase.getLogFile().err2File(ex, "MainGUI.developmentAction");
        }
    }

    private void rebuildWindowsMenu() {
        JInternalFrame[] frames = this.panelDesktop.getAllFrames();
        try {
            this.menuWindow.remove(this.menuItemWindowSeparator);
            this.menuWindow.remove(this.menuItemCascadeWindow);
            for (int i = 0; i < this.menuItemRadioWindowsOpened.length; ++i) {
                this.menuWindow.remove(this.menuItemRadioWindowsOpened[i]);
            }
        }
        catch (Exception nothing) {
            // empty catch block
        }
        if (this.mainBase.getAllInternalFrames() > 0) {
            this.menuItemCascadeWindow = new JMenuItem();
            this.menuItemCascadeWindow.setText(this.mainBase.getLanguageEntry("MENU_CASCADE"));
            char[] mnemonics = this.mainBase.getLanguageEntry("MENU_CASCADE_MNEMONIC").toCharArray();
            this.menuItemCascadeWindow.setMnemonic(mnemonics[0]);
            this.menuWindow.add(this.menuItemCascadeWindow);
            this.menuItemCascadeWindow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    MainGUI.this.cascadeWindows();
                }
            });
            this.menuItemWindowSeparator = new JSeparator();
            this.menuWindow.add(this.menuItemWindowSeparator);
            this.menuItemRadioWindowsOpened = new JRadioButtonMenuItem[frames.length];
            ButtonGroup bgWindows = new ButtonGroup();
            for (int i = 0; i < frames.length; ++i) {
                JInternalFrame frame = frames[i];
                this.menuItemRadioWindowsOpened[i] = new JRadioButtonMenuItem();
                this.menuItemRadioWindowsOpened[i].setText(frame.getTitle());
                this.menuItemRadioWindowsOpened[i].setSelected(this.mainBase.isShowingFrame(frame));
                bgWindows.add(this.menuItemRadioWindowsOpened[i]);
                this.menuItemRadioWindowsOpened[i].addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        MainGUI.this.bringToFront(ae);
                    }
                });
                this.menuWindow.add(this.menuItemRadioWindowsOpened[i]);
            }
        }
    }

    protected JDesktopPane getDesktopPanel() {
        return this.panelDesktop;
    }

    private void bringToFront(ActionEvent event) {
        String PREOUTTEXT = "MainGUI.bringToFront";
        JInternalFrame[] frames = this.panelDesktop.getAllFrames();
        this.mainBase.debug("evt.getActionCommand(): " + event.getActionCommand(), "MainGUI.bringToFront");
        for (int i = 0; i < frames.length; ++i) {
            this.mainBase.debug("frames[i].getTitle(): " + frames[i].getTitle(), "MainGUI.bringToFront");
            if (event.getActionCommand().compareTo(frames[i].getTitle()) != 0) continue;
            try {
                frames[i].setSelected(true);
                return;
            }
            catch (PropertyVetoException ex_nothing) {
                // empty catch block
            }
        }
    }

    private void cascadeWindows() {
        int i;
        JInternalFrame[] frames = this.panelDesktop.getAllFrames();
        int xWidth = 30;
        int yWidth = 25;
        int x = 0;
        int y = 0;
        JInternalFrame frame = null;
        for (i = 0; i < frames.length; ++i) {
            frame = frames[i];
            try {
                frame.setMaximum(false);
                frame.setSelected(true);
            }
            catch (PropertyVetoException ex_nothing) {
                // empty catch block
            }
            frame.setLocation(x, y);
            frame.toFront();
            x += xWidth;
            y += yWidth;
        }
        if (frame != null) {
            for (i = 0; i < this.menuItemRadioWindowsOpened.length; ++i) {
                if (frame.getTitle().compareTo(this.menuItemRadioWindowsOpened[i].getText()) != 0) continue;
                this.menuItemRadioWindowsOpened[i].setSelected(true);
                return;
            }
        }
    }

    private void setMultilignualism() {
        this.menuFile.setText(this.mainBase.getLanguageEntry("MENU_FILE"));
        char[] mnemonics = this.mainBase.getLanguageEntry("MENU_FILE_MNEMONIC").toCharArray();
        this.menuFile.setMnemonic(mnemonics[0]);
        this.menuItemExit.setText(this.mainBase.getLanguageEntry("MENU_EXIT"));
        mnemonics = this.mainBase.getLanguageEntry("MENU_EXIT_MNEMONIC").toCharArray();
        this.menuItemExit.setMnemonic(mnemonics[0]);
        this.menuConfiguration.setText(this.mainBase.getLanguageEntry("MENU_CONFIGURATION"));
        mnemonics = this.mainBase.getLanguageEntry("MENU_CONFIGURATION_MNEMONIC").toCharArray();
        this.menuConfiguration.setMnemonic(mnemonics[0]);
        this.menuWindow.setText(this.mainBase.getLanguageEntry("MENU_WINDOW"));
        mnemonics = this.mainBase.getLanguageEntry("MENU_WINDOW_MNEMONIC").toCharArray();
        this.menuWindow.setMnemonic(mnemonics[0]);
        this.menuHelp.setText(this.mainBase.getLanguageEntry("MENU_HELP"));
        mnemonics = this.mainBase.getLanguageEntry("MENU_HELP_MNEMONIC").toCharArray();
        this.menuHelp.setMnemonic(mnemonics[0]);
        this.menuItemAbout.setText(this.mainBase.getLanguageEntry("MENU_ABOUT"));
        mnemonics = this.mainBase.getLanguageEntry("MENU_ABOUT_MNEMONIC").toCharArray();
        this.menuItemAbout.setMnemonic(mnemonics[0]);
        this.menuLanguages.setText(this.mainBase.getLanguageEntry("MENU_LANGUAGE"));
        mnemonics = this.mainBase.getLanguageEntry("MENU_LANGUAGE_MNEMONIC").toCharArray();
        this.menuLanguages.setMnemonic(mnemonics[0]);
        this.menuHelpMe.setText(this.mainBase.getLanguageEntry("MENU_HELP"));
        this.menuItemClearOutputWindow.setText(this.mainBase.getLanguageEntry("MENU_CLEAR_OUTPUT_WINDOW"));
        this.menuOutput.setText(this.mainBase.getLanguageEntry("MENU_OUTPUT"));
        this.menuItemDetailedOutput.setText(this.mainBase.getLanguageEntry("MENU_D_OUTPUT"));
    }

    private void chooseScreenResolution(ActionEvent arg) {
        String PREOUTTEXT = "MainGUI.chooseScreenResolution";
        this.mainBase.debug("ScreenResolution: " + arg.getActionCommand(), "MainGUI.chooseScreenResolution");
        int pos = arg.getActionCommand().indexOf("x");
        int len = arg.getActionCommand().length();
        int width = new Integer(arg.getActionCommand().substring(0, pos));
        int height = new Integer(arg.getActionCommand().substring(pos + 1, len));
        this.mainBase.debug("width/height " + width + "/" + height, "MainGUI.chooseScreenResolution");
        Rectangle rect = this.getBounds();
        rect.setSize(width, height);
        this.setBounds(rect);
    }

    private void chooseLanguage(ActionEvent arg) {
        String PREOUTTEXT = "MainGUI.chooseLanguage";
        for (int i = 0; i < this.availableLanguages.length; ++i) {
            if (arg.getActionCommand().compareTo(this.availableLanguages[i]) != 0) continue;
            try {
                this.defaultLanguage = this.availableLanguages[i];
                this.getMainBase().getConfigFile().setConfigFileValue(this.getMainBase().getApplicationName(), "lang", this.defaultLanguage);
                Locale.setDefault(new Locale(this.defaultLanguage));
                return;
            }
            catch (Exception ex) {
                this.mainBase.getLogFile().err2File(ex, "MainGUI.chooseLanguage");
            }
        }
    }

    private void chooseLookAndFeel(ActionEvent arg) {
        String PREOUTTEXT = "MainGUI.chooseLookAndFeel";
        for (int i = 0; i < this.availableLookAndFeels.length; ++i) {
            if (arg.getActionCommand().compareTo(this.availableLookAndFeels[i].getName()) != 0) continue;
            try {
                this.selectedLookAndFeelClassName = this.availableLookAndFeels[i].getClassName();
                UIManager.setLookAndFeel(this.selectedLookAndFeelClassName);
                SwingUtilities.updateComponentTreeUI(this);
                return;
            }
            catch (Exception ex) {
                this.mainBase.getLogFile().err2File(ex, "MainGUI.chooseLookAndFeel");
            }
        }
    }

    public void addOutputText(Object obj) {
        String tmp = "\n\r";
        if (obj != null) {
            tmp = obj.toString() + "\n\r";
        }
        this.outputWindow.append(tmp);
    }

    public void addOutputText(Throwable th) {
        if (th != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream tmp = new PrintStream(baos);
            th.printStackTrace(tmp);
            this.addOutputText(new String(baos.toByteArray()));
        }
    }

    public void addOutputTextDetailed(String text) {
        if (this.detailedOutput) {
            this.addOutputText(text);
        }
    }

    protected JSplitPane getPanelSplit() {
        return this.panelSplit;
    }

    public void addOutputTextDetailed(Throwable th) {
        if (this.detailedOutput) {
            this.addOutputText(th);
        }
    }

    public JMenuItem getMenuItemFileExit() {
        return this.menuItemExit;
    }

    protected void menuFileClicked(MenuEvent evt) {
    }

    private void initComponents() {
        this.panelSplit = new JSplitPane();
        this.panelDesktop = new JDesktopPane();
        this.panelScroll = new JScrollPane();
        this.outputWindow = new JTextArea();
        this.menuBarMain = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuItemExit = new JMenuItem();
        this.menuConfiguration = new JMenu();
        this.menuLanguages = new JMenu();
        this.menuLookAndFeel = new JMenu();
        this.menuWindow = new JMenu();
        this.menuOutput = new JMenu();
        this.menuItemDetailedOutput = new JCheckBoxMenuItem();
        this.menuItemClearOutputWindow = new JMenuItem();
        this.menuHelp = new JMenu();
        this.menuHelpMe = new JMenuItem();
        this.menuItemAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Franzi");
        this.panelSplit.setDividerLocation(400);
        this.panelSplit.setOrientation(0);
        this.panelSplit.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MainGUI.this.panelSplitPropertyChange(evt);
            }
        });
        this.panelDesktop.setPreferredSize(null);
        this.panelSplit.setTopComponent(this.panelDesktop);
        this.outputWindow.setEditable(false);
        this.outputWindow.setColumns(20);
        this.outputWindow.setFont(new Font("Cordia New", 0, 16));
        this.outputWindow.setRows(5);
        this.panelScroll.setViewportView(this.outputWindow);
        this.panelSplit.setRightComponent(this.panelScroll);
        this.menuFile.setMnemonic('F');
        this.menuFile.setText("File");
        this.menuFile.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainGUI.this.menuFileMenuSelected(evt);
            }
        });
        this.menuItemExit.setText("Exit");
        this.menuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemExitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuItemExit);
        this.menuBarMain.add(this.menuFile);
        this.menuConfiguration.setMnemonic('C');
        this.menuConfiguration.setText("Configuration");
        this.menuLanguages.setText("jMenu1");
        this.menuConfiguration.add(this.menuLanguages);
        this.menuLookAndFeel.setMnemonic('L');
        this.menuLookAndFeel.setText("Look & Feel");
        this.menuConfiguration.add(this.menuLookAndFeel);
        this.menuBarMain.add(this.menuConfiguration);
        this.menuWindow.setMnemonic('W');
        this.menuWindow.setText("Window");
        this.menuWindow.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
                MainGUI.this.menuWindowMenuCanceled(evt);
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
                MainGUI.this.menuWindowMenuDeselected(evt);
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                MainGUI.this.menuWindowMenuSelected(evt);
            }
        });
        this.menuOutput.setMnemonic('O');
        this.menuOutput.setText("Output");
        this.menuItemDetailedOutput.setMnemonic('d');
        this.menuItemDetailedOutput.setSelected(true);
        this.menuItemDetailedOutput.setText("detailed Output");
        this.menuItemDetailedOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemDetailedOutputActionPerformed(evt);
            }
        });
        this.menuOutput.add(this.menuItemDetailedOutput);
        this.menuItemClearOutputWindow.setMnemonic('c');
        this.menuItemClearOutputWindow.setText("clear Output-Window");
        this.menuItemClearOutputWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemClearOutputWindowActionPerformed(evt);
            }
        });
        this.menuOutput.add(this.menuItemClearOutputWindow);
        this.menuWindow.add(this.menuOutput);
        this.menuBarMain.add(this.menuWindow);
        this.menuHelp.setMnemonic('H');
        this.menuHelp.setText("Help");
        this.menuHelpMe.setText("Help");
        this.menuHelp.add(this.menuHelpMe);
        this.menuItemAbout.setMnemonic('A');
        this.menuItemAbout.setText("About");
        this.menuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainGUI.this.menuItemAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.menuItemAbout);
        this.menuBarMain.add(this.menuHelp);
        this.setJMenuBar(this.menuBarMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelSplit, -1, 660, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelSplit, GroupLayout.Alignment.TRAILING, -1, 617, Short.MAX_VALUE));
        this.pack();
    }

    private void menuItemExitActionPerformed(ActionEvent evt) {
        String PREOUTTEXT = "MainGUI.menuItemExitActionPerformed";
        this.getMainBase().debug("Exit clicked", "MainGUI.menuItemExitActionPerformed");
        if (this.getExtendedState() != 6) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension screenSize = toolkit.getScreenSize();
            Dimension mySize = this.getSize();
            Rectangle rect = this.getBounds();
            if (rect.x + mySize.width < screenSize.width && rect.y + mySize.height < screenSize.height) {
                this.getMainBase().debug("save window size and position", "MainGUI.menuItemExitActionPerformed");
                this.getMainBase().getConfigFile().setConfigFileValue("Window", "extendedState", this.getExtendedState());
                this.getMainBase().getConfigFile().setConfigFileValue("Window", "width", mySize.width);
                this.getMainBase().getConfigFile().setConfigFileValue("Window", "height", mySize.height);
                this.getMainBase().getConfigFile().setConfigFileValue("Window", "x", rect.x);
                this.getMainBase().getConfigFile().setConfigFileValue("Window", "y", rect.y);
            }
        } else {
            this.getMainBase().debug("save Maximized window", "MainGUI.menuItemExitActionPerformed");
            this.getMainBase().getConfigFile().setConfigFileValue("Window", "extendedState", this.getExtendedState());
        }
        this.getMainBase().debug("save Look & Feel", "MainGUI.menuItemExitActionPerformed");
        this.getMainBase().getConfigFile().setConfigFileValue(this.getMainBase().getApplicationName(), "lookandfeel", this.selectedLookAndFeelClassName);
        if (this.detailedOutput) {
            this.getMainBase().getConfigFile().setConfigFileValue(this.getMainBase().getApplicationName(), "detailedOutput", "1");
        } else {
            this.getMainBase().getConfigFile().setConfigFileValue(this.getMainBase().getApplicationName(), "detailedOutput", "0");
        }
        try {
            this.getMainBase().getConfigFile().storeConfigFile();
            this.getMainBase().debug("Config-File saved", "MainGUI.menuItemExitActionPerformed");
        }
        catch (IOException ex) {
            this.getMainBase().getLogFile().log2File(ex, "MainGUI.menuItemExitActionPerformed");
        }
        this.getMainBase().closeApplication();
    }

    private void menuWindowMenuCanceled(MenuEvent evt) {
    }

    private void menuWindowMenuDeselected(MenuEvent evt) {
    }

    private void menuWindowMenuSelected(MenuEvent evt) {
        if (this.menuItemRadioWindowsOpened != null) {
            if (this.menuItemRadioWindowsOpened.length != this.mainBase.getAmountOfFrames()) {
                this.rebuildWindowsMenu();
            }
        } else if (this.mainBase.getAmountOfFrames() != 0) {
            this.rebuildWindowsMenu();
        }
    }

    private void menuItemClearOutputWindowActionPerformed(ActionEvent evt) {
        String PREOUTTEXT = "MainGUI.menuItemClearOutputWindowActionPerformed";
        this.getMainBase().debug("Clear Output Window Selected", "MainGUI.menuItemClearOutputWindowActionPerformed");
        this.mainBase.getLogFile().log2File(this.mainBase.getLanguageEntry("NMSG_OWINDOW_CLEANED"), "MainGUI.menuItemClearOutputWindowActionPerformed");
        this.mainBase.getLogFile().log2File("=======================================================================", "MainGUI.menuItemClearOutputWindowActionPerformed");
        this.mainBase.getLogFile().log2File(this.outputWindow.getText());
        this.mainBase.getLogFile().log2File("=======================================================================", "MainGUI.menuItemClearOutputWindowActionPerformed");
        this.outputWindow.setText(null);
    }

    private void menuItemAboutActionPerformed(ActionEvent evt) {
        this.getMainBase().debug("About clicked", "MainGUI.AboutClicked");
        this.aboutBox = new DialogAboutBox((Frame)this, true, "COA");
        this.aboutBox.setVisible(true);
    }

    private void menuItemDetailedOutputActionPerformed(ActionEvent evt) {
        this.detailedOutput = ((AbstractButton)evt.getSource()).getModel().isSelected();
        if (this.detailedOutput) {
            this.addOutputTextDetailed("\n\r" + this.mainBase.getLanguageEntry("MSG_D_OUTPUT_ON"));
        } else {
            this.addOutputText("\n\r" + this.mainBase.getLanguageEntry("MSG_D_OUTPUT_OFF"));
        }
    }

    private void menuFileMenuSelected(MenuEvent evt) {
        this.menuFileClicked(evt);
    }

    private void panelSplitPropertyChange(PropertyChangeEvent evt) {
        try {
            this.getMainBase().getConfigFile().setConfigFileValue("Window", "dividerHeight", this.getPanelSplit().getDividerLocation());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

