/*
 * Decompiled with CFR 0.152.
 */
package at.glawar.javaframework.utils;

import at.glawar.javaframework.MainBase;
import at.glawar.javaframework.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Files {
    private Files() {
    }

    public static void copyFileUsingStream(String source, String dest) throws FileNotFoundException, IOException {
        File sourceFile = new File(source);
        File destFile = new File(dest);
        Files.copyFileUsingStream(sourceFile, destFile);
    }

    public static void copyFileUsingStream(File source, File dest) throws FileNotFoundException, IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ex) {}
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public static void archiveTargetFileBefore(MainBase mainBase, String fullSourceFilePath, int maxArchives) throws FileNotFoundException, IOException {
        if (maxArchives != 0) {
            String retVal = fullSourceFilePath;
            File sourceFile = new File(fullSourceFilePath);
            int i = 1;
            Files.doDebug(mainBase, "Input=" + retVal);
            while (sourceFile.exists()) {
                retVal = StringUtils.addAddTextIntoFileName(fullSourceFilePath, "" + i);
                Files.doDebug(mainBase, "B=" + retVal);
                sourceFile = new File(retVal);
                ++i;
            }
            Files.doDebug(mainBase, "Determined <" + --i + ">");
            if (maxArchives > 0 && i >= maxArchives) {
                Files.doDebug(mainBase, "maxArchives is activated an has reached <" + maxArchives + ">");
                File lastFile = new File(StringUtils.addAddTextIntoFileName(fullSourceFilePath, "" + maxArchives));
                if (lastFile.exists() && lastFile.isFile()) {
                    Files.doDebug(mainBase, "Max archived file <" + lastFile.getAbsolutePath() + "> exists and will be deleted");
                    lastFile.delete();
                    --i;
                }
            }
            for (int j = i; j > 0; --j) {
                String source = null;
                source = j - 1 == 0 ? fullSourceFilePath : StringUtils.addAddTextIntoFileName(fullSourceFilePath, "" + (j - 1));
                String target = StringUtils.addAddTextIntoFileName(fullSourceFilePath, "" + j);
                Files.doDebug(mainBase, "Archive-copy <" + source + "> to <" + target + ">");
                Files.copyFileUsingStream(source, target);
            }
            Files.doDebug(mainBase, "Finished");
        }
    }

    public static void copyFileWithBackup(MainBase mainBase, String fullSourceFile, String fullDestDir, int maxArchives) throws IOException {
        File sourceFile = new File(fullSourceFile);
        File destDir = new File(fullDestDir);
        Files.doDebug(mainBase, "copyFileWithBackup");
        if (!sourceFile.exists() && !sourceFile.isFile()) {
            Files.doDebug(mainBase, "SourceFile <" + fullSourceFile + "> not found");
        } else if (!destDir.isDirectory() && !destDir.exists()) {
            Files.doDebug(mainBase, "Destination Directory <" + fullDestDir + "> not found");
        } else {
            Files.archiveTargetFileBefore(mainBase, destDir.getAbsolutePath() + File.separator + sourceFile.getName(), maxArchives);
            Files.doLog(mainBase, "We will copy <" + sourceFile.getAbsolutePath() + "> to <" + destDir.getAbsolutePath() + ">");
            Files.copyFileUsingStream(sourceFile.getAbsolutePath(), destDir.getAbsolutePath() + File.separator + sourceFile.getName());
        }
    }

    private static void doDebug(MainBase mainBase, String debugText) {
        if (mainBase != null) {
            mainBase.debug(debugText);
        } else {
            System.out.println(debugText);
        }
    }

    private static void doLog(MainBase mainBase, String logText) {
        if (mainBase != null) {
            mainBase.getLogFile().log2File(logText);
        } else {
            System.out.println(logText);
        }
    }
}

